% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{fin_JustifiedPE}
\alias{fin_JustifiedPE}
\title{Justified P/E Ratio}
\usage{
fin_JustifiedPE(
  Dividend = 0.02,
  EPS = 1,
  growthRate = 0.08,
  discountRate = 0.12,
  basePE = 20,
  yrs = 10
)
}
\arguments{
\item{Dividend}{The dividend.}

\item{EPS}{The Earnings per Share.}

\item{growthRate}{The growth rate.}

\item{discountRate}{Your chosen discount rate.}

\item{basePE}{The base PE.}

\item{yrs}{Years.}
}
\value{
\itemize{
\item A PE that is justified for this stock.
}
}
\description{
Compute the Justified P/E of a stock.
Justified P/E = ( (DPS / EPS) * (1 + g)) / (k – g)
DPS is the dividend per share, EPS is the earnings per share,
g is the sustainable growth rate, and k is the required rate of return.
}
\examples{
# fin_JustifiedPE(Dividend= .8, EPS = 2, growthRate = .06, discountRate = .1)

}
\seealso{
\itemize{
\item \code{\link[=fin_interest]{fin_interest()}}, \code{\link[=fin_percent]{fin_percent()}}, \code{\link[=fin_NI]{fin_NI()}}
}

Other Miscellaneous Functions: 
\code{\link{deg2rad}()},
\code{\link{fin_NI}()},
\code{\link{fin_interest}()},
\code{\link{fin_percent}()},
\code{\link{fin_ticker}()},
\code{\link{fin_valuation}()},
\code{\link{rad2deg}()},
\code{\link{umxBrownie}()}
}
\concept{Miscellaneous Functions}
