% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaning.R
\name{get_meteo_available}
\alias{get_meteo_available}
\title{Get Available Meteorological Components}
\usage{
get_meteo_available(env_data)
}
\arguments{
\item{env_data}{Data table containing environmental data.
Must contain column "Komponente"}
}
\value{
A vector of available meteorological components.
}
\description{
Identifies unique meteorological components from the provided environmental data,
filtering only those that match the predefined UBA naming conventions. These components
include "GLO", "LDR", "RFE", "TMP", "WIG", "WIR", "WIND_U", and "WIND_V".
}
\examples{
# Example environmental data
env_data <- data.table::data.table(
  Komponente = c("TMP", "NO2", "GLO", "WIR"),
  Wert = c(25, 40, 300, 50),
  date = as.POSIXct(c(
    "2023-01-01 08:00:00", "2023-01-01 09:00:00",
    "2023-01-01 10:00:00", "2023-01-01 11:00:00"
  ))
)
# Get available meteorological components
meteo_components <- get_meteo_available(env_data)
print(meteo_components)
}
