% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.1.0.R
\name{tsmodeleval}
\alias{tsmodeleval}
\title{Goodness of Fit of a Time Series Model}
\usage{
tsmodeleval(object)
}
\arguments{
\item{object}{a time series model of class `\code{tsarima}`, `\code{tsesm}`, or `\code{tsmovav}`. It can also be a list with at least the two elements: `\code{x}` and `\code{fitted}`.}
}
\value{
A list with the following model evaluation criteria:

\item{ME}{mean error}

\item{RMSE}{Root mean square error}

\item{MAE}{mean absolute error}

\item{MPE}{mean percentage error}

\item{MAPE}{mean absolute percentage error}

\item{MASE}{mean absolute scaled error}

\item{MASE.S}{seasonal mean absolute scaled error}

\item{ACF1}{lag 1 autocorrelation}
}
\description{
The function `\code{tsmodeleval}` can be used to evaluate the goodness of fit of a time series model.
}
\examples{
tsmodeleval(tsarima(airport$Travellers, 
                    order = c(1, 1, 0), seasonal = c(0, 1, 1),
                    log = TRUE, include.const = TRUE))
}
\references{
Hyndman, R. J., Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}
}
\author{
Ka Yui Karl Wu
}
