% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm.R
\name{fetch_osm_roads}
\alias{fetch_osm_roads}
\title{Fetch road geometries from OpenStreetMap}
\usage{
fetch_osm_roads(
  place,
  key = "highway",
  value = NULL,
  extra_tags = NULL,
  layer = c("osm_lines", "osm_multilines", "osm_polygons", "osm_multipolygons"),
  quiet = TRUE,
  ...
)
}
\arguments{
\item{place}{A character place name (passed to `osmdata::getbb()`) or a
bounding box object accepted by `osmdata::opq()`.}

\item{key}{OSM feature key to query. Default is `"highway"`.}

\item{value}{Optional character vector of OSM feature values.
For example, `c("primary", "secondary")`.}

\item{extra_tags}{Optional named list of additional tags passed to
`osmdata::add_osm_feature()`.}

\item{layer}{Which OSM layer to return. Defaults to `"osm_lines"`.}

\item{quiet}{Logical; suppress osmdata messages. Default TRUE.}

\item{...}{Additional arguments passed to `osmdata::osmdata_sf()`.}
}
\value{
An `sf` object with road geometries.
}
\description{
Convenience wrapper around `osmdata` to download road geometries and
return an `sf` object that can be passed into `roads_to_segments()`.
}
