% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chemical_summary.R
\name{remove_flags}
\alias{remove_flags}
\title{Remove endpoints with specific data quality flags from data}
\usage{
remove_flags(ACC, flag_id = c(5, 6, 11, 15, 18))
}
\arguments{
\item{ACC}{data frame with columns: casn, chnm, endPoint, and ACC_value}

\item{flag_id}{vector of flags to to trigger REMOVAL}
}
\description{
Through the ToxCast program quality assurance procedures, information
is examined and at times, it is necessary to assign a data quality flag
to a specific chemical/assay result. A toxEval user may want to include
or exclude assay results with certain flags depending on the objectives
of a given study. Assay results with specific data quality flags assigned
to them can be removed based on their designated flag with the
\code{remove_flags} function. The flags included in ToxCast, and the associated
flagsShort value (used in the remove_flags function) are as follows:
\tabular{ll}{
\strong{flag_id} \tab \strong{Full Name}\cr
5* \tab Model directionality questionable \cr
6* \tab Only highest conc above baseline, active \cr
7 \tab Only one conc above baseline, active \cr
8 \tab Multiple points above baseline, inactive \cr
9 \tab Bmd > ac50, indication of high baseline variability \cr
10 \tab Noisy data \cr
11* \tab Borderline \cr
15* \tab Gain AC50 < lowest conc & loss AC50 < mean conc \cr
17 \tab Less than 50\% efficacy \cr
18* \tab AC50 less than lowest concentration tested \cr
13 \tab Average number of replicates per conc is less than 2 \cr
14 \tab Number of concentrations tested is less than 4 \cr
19 \tab Cell viability assay fit with gnls winning model \cr
}
Asterisks indicate flags removed in the function as default.
}
\examples{
CAS <- c("121-00-6", "136-85-6", "80-05-7", "84-65-1", "5436-43-1", "126-73-8")
ACC <- get_ACC(CAS)
nrow(ACC)

# See available flags and associated ids:

flags

ACC <- remove_flags(ACC)
nrow(ACC)
}
