% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_violin.R
\name{type_violin}
\alias{type_violin}
\title{Violin plot type}
\usage{
type_violin(
  bw = "nrd0",
  joint.bw = c("mean", "full", "none"),
  adjust = 1,
  kernel = c("gaussian", "epanechnikov", "rectangular", "triangular", "biweight",
    "cosine", "optcosine"),
  n = 512,
  trim = FALSE,
  width = 0.9
)
}
\arguments{
\item{bw}{the smoothing bandwidth to be used.  The kernels are scaled
    such that this is the standard deviation of the smoothing kernel.
    (Note this differs from the reference books cited below.)

    \code{bw} can also be a character string giving a rule to choose the
    bandwidth.  See \code{\link[stats]{bw.nrd}}. \cr The default,
    \code{"nrd0"}, has remained the default for historical and
    compatibility reasons, rather than as a general recommendation,
    where e.g., \code{"SJ"} would rather fit, see also
    Venables and Ripley (2002).

    The specified (or computed) value of \code{bw} is multiplied by
    \code{adjust}.
  }

\item{joint.bw}{character string indicating whether (and how) the smoothing
bandwidth should be computed from the joint data distribution when there
are multiple subgroups. The options are \code{"mean"} (the default), \code{"full"},
and \code{"none"}. Also accepts a logical argument, where \code{TRUE} maps to
\code{"mean"} and \code{FALSE} maps to \code{"none"}. See the "Bandwidth selection"
section below for a discussion of practical considerations.}

\item{adjust}{the bandwidth used is actually \code{adjust*bw}.
    This makes it easy to specify values like \sQuote{half the default}
    bandwidth.}

\item{kernel}{a character string giving the smoothing kernel to be used. This
must partially match one of \code{"gaussian"}, \code{"rectangular"}, \code{"triangular"},
\code{"epanechnikov"}, \code{"biweight"}, \code{"cosine"} or \code{"optcosine"}, with default
\code{"gaussian"}, and may be abbreviated to a unique prefix (single letter).

\code{"cosine"} is smoother than \code{"optcosine"}, which is the usual 'cosine'
kernel in the literature and almost MSE-efficient. However, \code{"cosine"} is
the version used by S.}

\item{n}{the number of equally spaced points at which the density is
    to be estimated.  When \code{n > 512}, it is rounded up to a power
    of 2 during the calculations (as \code{\link[stats]{fft}} is used) and the
    final result is interpolated by \code{\link[stats]{approx}}.  So it almost
    always makes sense to specify \code{n} as a power of two.
  }

\item{trim}{logical indicating whether the violins should be trimmed to the
range of the data. Default is \code{FALSE}.}

\item{width}{numeric (ideally in the range \verb{[0, 1]}, although this isn't
enforced) giving the normalized width of the individual violins.}
}
\description{
Type function for violin plots, which are an alternative to box
plots for visualizing continuous distributions (by group) in the form of
mirrored densities.
}
\details{
See \code{\link{type_density}} for more details and considerations related to
bandwidth selection and kernel types.
}
\examples{
# "violin" type convenience string
tinyplot(count ~ spray, data = InsectSprays, type = "violin")

# aside: to match the defaults of `ggplot2::geom_violin()`, use `trim = TRUE`
# and `joint.bw = FALSE`
tinyplot(count ~ spray, data = InsectSprays, type = "violin",
    trim = TRUE, joint.bw = FALSE)

# use flip = TRUE to reorient the axes
tinyplot(count ~ spray, data = InsectSprays, type = "violin", flip = TRUE)

# for flipped plots with long group labels, it's better to use a theme for
# dynamic plot resizing
tinytheme("clean")
tinyplot(weight ~ feed, data = chickwts, type = "violin", flip = TRUE)

# you can group by the x var to add colour (here with the original orientation)
tinyplot(weight ~ feed | feed, data = chickwts, type = "violin", legend = FALSE)

# dodged grouped violin plot example (different dataset)
tinyplot(len ~ dose | supp, data = ToothGrowth, type = "violin", fill = 0.2)

# note: above we relied on `...` argument passing alongside the "violin"
# type convenience string. But this won't work for `width`, since it will
# clash with the top-level `tinyplot(..., width = <width>)` arg. To ensure
# correct arg passing, it's safer to use the formal `type_violin()` option.
tinyplot(len ~ dose | supp, data = ToothGrowth, fill = 0.2,
    type = type_violin(width = 0.8))

# reset theme
tinytheme()

}
