% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atomic_typecast.R
\name{atomic_typecast}
\alias{atomic_typecast}
\alias{as_bool}
\alias{as_int}
\alias{as_dbl}
\alias{as_chr}
\alias{as_cplx}
\alias{as_raw}
\title{Atomic Type Casting With Names and Dimensions Preserved}
\usage{
as_bool(x, ...)

as_int(x, ...)

as_dbl(x, ...)

as_chr(x, ...)

as_cplx(x, ...)

as_raw(x, ...)
}
\arguments{
\item{x}{vector, matrix, array
(or a similar object where all elements share the same type).}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The converted object. \cr \cr
}
\description{
Atomic type casting in R is generally performed using the functions
\link[base]{as.logical}, \link[base]{as.integer},
\link[base]{as.double}, \link[base]{as.character},
\link[base]{as.complex}, and \link[base]{as.raw}. \cr
\cr
Converting an object between atomic types using these functions
strips the object of its attributes,
including (dim)names and dimensions. \cr
\cr
The functions provided here by the 'tinycodet' package
preserve the dimensions, dimnames, and names. \cr
\cr
The functions are as follows: \cr
\itemize{
\item \code{as_bool()}: converts object to atomic type \code{logical} (\code{TRUE, FALSE, NA}).
\item \code{as_int()}: converts object to atomic type \code{integer}.
\item \code{as_dbl()}: converts object to atomic type \code{double} (AKA decimal numbers).
\item \code{as_chr()}: converts object to atomic type \code{character}.
\item \code{as_cplx()}: converts object to atomic type \code{complex}.
\item \code{as_raw()}:converts object to atomic type \code{raw}.
}
}
\examples{

# matrix example ====
x <- matrix(sample(-1:28), ncol = 5)
colnames(x) <- month.name[1:5]
rownames(x) <- month.abb[1:6]
names(x) <- c(letters[1:20], LETTERS[1:10])
print(x)

as_bool(x)
as_int(x)
as_dbl(x)
as_chr(x)
as_cplx(x)
as_raw(x)


################################################################################

# factor example ====
x <- factor(month.abb, levels = month.abb)
names(x) <- month.name
print(x)

as_bool(as_int(x) > 6)
as_int(x)
as_dbl(x)
as_chr(x)
as_cplx(x)
as_raw(x)
}
\seealso{
\link{tinycodet_dry}
}
