% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/many_maps.R
\name{many_maps}
\alias{many_maps}
\title{Generate Many Tile Maps}
\usage{
many_maps(
  data,
  labels,
  square = TRUE,
  flat_topped = FALSE,
  prop = c(0, 0.05),
  interpolate = c(0.5, 1),
  smoothness = c(0, 5),
  shift = list(c(0, 0), c(0.5, 0), c(0, 0.5)),
  weights = c(1, 1, 1, 1),
  plot = TRUE,
  size = 2
)
}
\arguments{
\item{data}{An object of class \code{sfc_MULTIPOLYGON} or
\code{sfc_POLYGON}, which contains the regions that make up the original
map.}

\item{labels}{A character vector with the labels of the regions. Labels must
be in the same order as regions given for \code{data} argument.}

\item{square}{logical. If \code{TRUE}, generates a square tile map. If
\code{FALSE}, generates a hexagon tile map.}

\item{flat_topped}{logical. If \code{TRUE}, hexagons are flat-topped. If
\code{FALSE}, hexagons are pointy-topped.}

\item{prop}{A numeric vector of proportions used in specifying the standard
deviation of the Gaussian noise added to original region centroids. The
standard deviation of the Gaussian noise is calculated as the mean
distance between a region centroid and its neighboring regions' centroids
multiplied by the value provided for the \code{prop} argument. A different
set of noisy region centroids is created for each given value.}

\item{interpolate}{A numeric vector of values between 0 and 1 controlling
the linear interpolation between the noisy region centroids and
fully-transformed region centroids. If 0, noisy region centroids are used.
If 1, fully-transformed centroids are used. A different set of
interpolated centroids is created for each given value.}

\item{smoothness}{numeric vector. Controls the bandwidth of the Gaussian
kernel used for smoothing the transformed boundary polygon. The bandwidth
is calculated as the mean distance between adjacent boundary points
multiplied by the value provided for the \code{smoothness} argument. A
different transformed boundary is created for each given value.}

\item{shift}{A list of numeric vectors of length two specifying the number
of grid steps to shift the candidate tile map in the x and y directions
before counting the number of tile centroids that lie within the
transformed boundary. A different final tile map is created for each given
value.}

\item{weights}{A numeric vector of length 4 specifying the weights used for
calculating the total cost. The first, second, third, and fourth weights
are applied to the location, adjacency, angle, and roughness costs,
respectively.}

\item{plot}{logical. If \code{TRUE}, prints plot of generated tile maps.}

\item{size}{numeric. Controls size of labels in plot.}
}
\value{
Returns a \code{data.frame} in which each row corresponds to one map
 and the columns contain the generated maps, the parameters used for
 creating the maps, and the costs associated with each map. The
 \code{data.frame} is ordered by the total cost.
}
\description{
Generate, plot, and compare many tile maps.
}
\details{
Generates many candidate tile maps using an algorithm proposed in
\emph{"Generating Tile Maps"} (McNeill and Hale 2017). The regions of the
map must be contiguous. Coordinates cannot be in terms of latitude and
longitude. Instead the coordinate reference system must be an appropriate
planar projection. The number of maps generated is equal to the product of
the lengths of the \code{prop}, \code{interpolate}, \code{smoothness}, and
\code{shift} arguments.
}
\examples{
library(sf)
northeast <- governors[c(6,7,17,18,19,27,28,30,36,37,43),]
ne_maps <- many_maps(northeast$geometry, northeast$abbreviation,
                     prop = 0, interpolate = 1, smoothness = c(0,20),
                     shift = list(c(0,0), c(0,0.5)))

}
\references{
McNeill, Graham, and Scott A Hale. 2017. “Generating Tile Maps.”
 In \emph{Computer Graphics Forum}, 36:435–45. 3. Wiley Online Library.
}
