% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_text.R
\name{generate_analysis}
\alias{generate_analysis}
\title{Generate analytical paragraphs (rule-based)}
\usage{
generate_analysis(
  df,
  classe_conama = "2",
  incluir_tendencia = TRUE,
  parametros_tendencia = c("turbidez", "od", "pH"),
  contexto = list(rio = NA, periodo = NA, cidade = NA)
)
}
\arguments{
\item{df}{Data frame contendo ao menos a coluna \code{ponto}. Recomenda-se
também as colunas necessárias para checagens CONAMA e para o cálculo do IQA.}

\item{classe_conama}{Character (ex. \code{"2"}). Classe‐alvo para a checagem da
Resolução CONAMA 357/2005.}

\item{incluir_tendencia}{Logical; se \code{TRUE}, calcula tendências lineares
simples ao longo do tempo.}

\item{parametros_tendencia}{Character vector; nomes dos parâmetros para testar
tendência temporal.}

\item{contexto}{Lista com metadados opcionais (PT/EN), por exemplo
\code{list(rio = "Rio Pardo", periodo = "jan–jun/2025", cidade = "Lençóis")}.
As chaves aceitas são \code{rio}/\code{river}, \code{periodo}/\code{period}, \code{cidade}.}
}
\value{
Vetor de \code{character} com 3 a 5 parágrafos analíticos prontos para relatório.
}
\description{
Produces 3–5 short, human-readable paragraphs summarizing water quality,
using IQA/WQI, CONAMA-357 compliance and (optionally) simple time trends.
It is \strong{rule-based} (não usa IA) e aceita metadados opcionais para compor o texto.
}
\examples{
\dontrun{
library(tikatuwq)
data("wq_demo")
txt <- generate_analysis(
  df = wq_demo,
  classe_conama = "2",
  incluir_tendencia = TRUE,
  parametros_tendencia = c("turbidez","od","pH"),
  contexto = list(rio = "Rio Azul", periodo = "jan–jun/2025")
)
cat(paste(txt, collapse = "\n\n"))
}

}
\seealso{
\code{\link[=iqa]{iqa()}}, \code{\link[=conama_check]{conama_check()}}
}
\concept{reporting-tools}
