% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{format_p_values_at}
\alias{format_p_values_at}
\title{Format numeric columns for display}
\usage{
format_p_values_at(
  .tbl,
  .vars,
  decimal_places = 3,
  prefix = "p",
  less_than_cutoff = 0.001,
  remove_trailing_zeroes = T,
  alpha = 0.05,
  ns_replacement = NULL
)
}
\arguments{
\item{.tbl}{A data frame}

\item{.vars}{A vars() list of symbolic columns}

\item{decimal_places}{Decimal places to display}

\item{prefix}{Prefix to prepend (default "p=")}

\item{less_than_cutoff}{Cut-off for small p values. Values smaller than this will be displayed like "p<..."}

\item{remove_trailing_zeroes}{If the required decimal places are less than decimal places,
should resulting trailing zeros be removed?}

\item{alpha}{Cut-off for assuming significance, usually 0.05}

\item{ns_replacement}{If p value is not significant (is > alpha), it will be replace by this string (e.g. "n.s.")
If NULL (default), no replacement is performed.

Vectorised (in parallel) over x, prefix, less_than_cutoff, alpha and ns_replacement.}
}
\value{
Value of mutate_at
}
\description{
Combines \code{\link[dplyr]{mutate_at}()} and \code{\link{as_formatted_p_value}()}
}
\examples{
library(tibble)
library(magrittr)
library(dplyr)
tibble(p=c(0.05, 0.0001)) \%>\%
    format_numbers_at(vars(p))
}
\seealso{
\code{\link{format_numbers_at}}
}
