% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loci_transversions.R
\name{loci_transversions}
\alias{loci_transversions}
\alias{loci_transversions.tbl_df}
\alias{loci_transversions.vctrs_bigSNP}
\title{Find transversions}
\usage{
loci_transversions(.x, .col = "genotypes", ...)

\method{loci_transversions}{tbl_df}(.x, .col = "genotypes", ...)

\method{loci_transversions}{vctrs_bigSNP}(.x, .col = "genotypes", ...)
}
\arguments{
\item{.x}{a vector of class \code{vctrs_bigSNP} (usually the \code{genotype} column of
a \code{\link{gen_tibble}} object),
or a \code{\link{gen_tibble}}.}

\item{.col}{the column to be used when a tibble (or grouped tibble is passed
directly to the function). This defaults to "genotypes" and can only take
that value. There is no need for the user to set it, but it is included to
resolve certain tidyselect operations.}

\item{...}{other arguments passed to specific methods.}
}
\value{
a logical vector defining which loci are transversions
}
\description{
Use the loci table to define which loci are transversions
}
\examples{
example_gt <- load_example_gt("gen_tbl")
example_gt \%>\% loci_transversions()
}
