% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_exist_meta.R
\name{tar_exist_meta}
\alias{tar_exist_meta}
\title{Check if target metadata exists.}
\usage{
tar_exist_meta(store = targets::tar_config_get("store"))
}
\arguments{
\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Logical of length 1, whether the current project's metadata exists.
}
\description{
Check if the target metadata file \verb{_targets/meta/meta}
exists for the current project.
}
\details{
To learn more about data storage in \code{targets}, visit
\url{https://books.ropensci.org/targets/data.html}.
}
\examples{
tar_exist_meta()
}
\seealso{
Other existence: 
\code{\link{tar_exist_objects}()},
\code{\link{tar_exist_process}()},
\code{\link{tar_exist_progress}()},
\code{\link{tar_exist_script}()}
}
\concept{existence}
