% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_quarto_rep_raw.R
\name{tar_quarto_rep_run_params}
\alias{tar_quarto_rep_run_params}
\title{Prepare Quarto parameters for \code{tar_quarto_rep()}.}
\usage{
tar_quarto_rep_run_params(execute_params, batches, default_output_file)
}
\arguments{
\item{execute_params}{Data frame of Quarto parameters.}

\item{batches}{Number of batches to split up the renderings.}

\item{default_output_file}{Default output file path deduced
from the YAML front-matter of the Quarto source document.}
}
\value{
A batched data frame of Quarto parameters.
}
\description{
Internal function needed for \code{tar_quarto_rep()}.
Users should not invoke it directly.
}
\examples{
execute_params <- tibble::tibble(param1 = letters[seq_len(4)])
tar_quarto_rep_run_params(execute_params, 1, "report.html")
tar_quarto_rep_run_params(execute_params, 2, "report.html")
tar_quarto_rep_run_params(execute_params, 3, "report.html")
tar_quarto_rep_run_params(execute_params, 4, "report.html")
}
\keyword{internal}
