% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_quarto.R, R/tar_quarto_raw.R
\name{tar_quarto}
\alias{tar_quarto}
\alias{tar_quarto_raw}
\title{Target with a Quarto project.}
\usage{
tar_quarto(
  name,
  path = ".",
  output_file = NULL,
  working_directory = NULL,
  extra_files = character(0),
  execute = TRUE,
  execute_params = list(),
  cache = NULL,
  cache_refresh = FALSE,
  debug = FALSE,
  quiet = TRUE,
  quarto_args = NULL,
  pandoc_args = NULL,
  profile = NULL,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = NULL,
  library = NULL,
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)

tar_quarto_raw(
  name,
  path = ".",
  output_file = NULL,
  working_directory = NULL,
  extra_files = character(0),
  execute = TRUE,
  execute_params = NULL,
  cache = NULL,
  cache_refresh = FALSE,
  debug = FALSE,
  quiet = TRUE,
  quarto_args = NULL,
  pandoc_args = NULL,
  profile = NULL,
  packages = NULL,
  library = NULL,
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = targets::tar_option_get("deployment"),
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  description = targets::tar_option_get("description")
)
}
\arguments{
\item{name}{Name of the target.
\code{\link[=tar_quarto]{tar_quarto()}} expects an unevaluated symbol for the \code{name}
argument, and
\code{\link[=tar_quarto_raw]{tar_quarto_raw()}} expects a character string for \code{name}.}

\item{path}{Character string, path to the Quarto source file if rendering
a single file, or the path to the root of the project if rendering
a whole Quarto project.}

\item{output_file}{The name of the output file. If using \code{NULL}, the output
filename will be based on the filename for the input file. \code{output_file} is
mapped to the \code{--output} option flag of the \code{quarto} CLI. It is expected to
be a filename only, not a path, relative or absolute.}

\item{working_directory}{Optional character string,
path to the working directory
to temporarily set when running the report.
The default is \code{NULL}, which runs the report from the
current working directory at the time the pipeline is run.
This default is recommended in the vast majority of cases.
To use anything other than \code{NULL}, you must manually set the value
of the \code{store} argument relative to the working directory in all calls
to \code{tar_read()} and \code{tar_load()} in the report. Otherwise,
these functions will not know where to find the data.}

\item{extra_files}{Character vector of extra files and
directories to track for changes. The target will be invalidated
(rerun on the next \code{tar_make()}) if the contents of these files changes.
No need to include anything already in the output of \code{\link[=tar_quarto_files]{tar_quarto_files()}},
the list of file dependencies automatically detected through
\code{quarto::quarto_inspect()}.}

\item{execute}{Whether to execute embedded code chunks.}

\item{execute_params}{Named collection of parameters
for parameterized Quarto documents. These parameters override the custom
custom elements of the \code{params} list in the YAML front-matter of the
Quarto source files.

\code{\link[=tar_quarto]{tar_quarto()}} expects an unevaluated expression for the
\code{execute_params} argument, whereas
\code{\link[=tar_quarto_raw]{tar_quarto_raw()}} expects an evaluated expression object.}

\item{cache}{Cache execution output (uses knitr cache and jupyter-cache
respectively for Rmd and Jupyter input files).}

\item{cache_refresh}{Force refresh of execution cache.}

\item{debug}{Leave intermediate files in place after render.}

\item{quiet}{Suppress warning and other messages.}

\item{quarto_args}{Character vector of other \code{quarto} CLI arguments to append
to the Quarto command executed by this function. This is mainly intended for
advanced usage and useful for CLI arguments which are not yet mirrored in a
dedicated parameter of this \R function. See \verb{quarto render --help} for options.}

\item{pandoc_args}{Additional command line arguments to pass on to Pandoc.}

\item{profile}{\href{https://quarto.org/docs/projects/profiles.html}{Quarto project profile(s)} to use. Either
a character vector of profile names or \code{NULL} to use the default profile.}

\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target runs or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline. In addition,
as of \code{targets} version 1.8.0.9011, a value of \code{NULL} is given
to upstream dependencies with \code{error = "null"} if loading fails.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
\item \code{"trim"}: all currently running targets stay running. A queued
target is allowed to start if:
\enumerate{
\item It is not downstream of the error, and
\item It is not a sibling branch from the same \code{\link[targets:tar_target]{tar_target()}} call
(if the error happened in a dynamic branch).
}

The idea is to avoid starting any new work that the immediate error
impacts. \code{error = "trim"} is just like \code{error = "abridge"},
but it allows potentially healthy regions of the dependency graph
to begin running.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
}}

\item{memory}{Character of length 1, memory strategy. Possible values:
\itemize{
\item \code{"auto"} (default): equivalent to \code{memory = "transient"} in almost
all cases. But to avoid superfluous reads from disk,
\code{memory = "auto"} is equivalent to \code{memory = "persistent"} for
for non-dynamically-branched targets that other targets
dynamically branch over. For example: if your pipeline has
\code{tar_target(name = y, command = x, pattern = map(x))},
then \code{tar_target(name = x, command = f(), memory = "auto")}
will use persistent memory in order to avoid rereading all of \code{x}
for every branch of \code{y}.
\item \code{"transient"}: the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
\item \code{"persistent"}: the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
}

For cloud-based file targets
(e.g. \code{format = "file"} with \code{repository = "aws"}),
the \code{memory} option applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical: \code{TRUE} to run \code{base::gc()}
just before the target runs, in whatever R process it is about to run
(which could be a parallel worker).
\code{FALSE} to omit garbage collection.
Numeric values get converted to \code{FALSE}.
The \code{garbage_collection} option in \code{\link[targets:tar_option_set]{tar_option_set()}}
is independent of the
argument of the same name in \code{\link[targets:tar_target]{tar_target()}}.}

\item{deployment}{Character of length 1. If \code{deployment} is
\code{"main"}, then the target will run on the central controlling R process.
Otherwise, if \code{deployment} is \code{"worker"} and you set up the pipeline
with distributed/parallel computing, then
the target runs on a parallel worker. For more on distributed/parallel
computing in \code{targets}, please visit
\url{https://books.ropensci.org/targets/crew.html}.}

\item{priority}{Deprecated on 2025-04-08 (\code{targets} version 1.10.1.9013).
\code{targets} has moved to a more efficient scheduling algorithm
(\url{https://github.com/ropensci/targets/issues/1458})
which cannot support priorities.
The \code{priority} argument of \code{\link[targets:tar_target]{tar_target()}} no longer has a reliable
effect on execution order.}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{retrieval}{Character string to control when the current target
loads its dependencies into memory before running.
(Here, a "dependency" is another target upstream that the current one
depends on.) Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"auto"} (default): equivalent to \code{retrieval = "worker"} in almost all
cases. But to avoid unnecessary reads from disk, \code{retrieval = "auto"}
is equivalent to \code{retrieval = "main"} for dynamic branches that
branch over non-dynamic targets. For example: if your pipeline has
\code{tar_target(x, command = f())}, then
\code{tar_target(y, command = x, pattern = map(x), retrieval = "auto")}
will use \code{"main"} retrieval in order to avoid rereading all of \code{x}
for every branch of \code{y}.
\item \code{"worker"}: the worker loads the target's dependencies.
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target runs.
\item \code{"none"}: \code{targets} makes no attempt to load its
dependencies. With \code{retrieval = "none"}, loading dependencies
is the responsibility of the user. Use with caution.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{description}{Character of length 1, a custom free-form human-readable
text description of the target. Descriptions appear as target labels
in functions like \code{\link[targets:tar_manifest]{tar_manifest()}} and \code{\link[targets:tar_visnetwork]{tar_visnetwork()}},
and they let you select subsets of targets for the \code{names} argument of
functions like \code{\link[targets:tar_make]{tar_make()}}. For example,
\code{tar_manifest(names = tar_described_as(starts_with("survival model")))}
lists all the targets whose descriptions start with the character
string \code{"survival model"}.}
}
\value{
A target object with \code{format = "file"}.
When this target runs, it returns a character vector
of file paths: the rendered documents, the Quarto source files,
and other input and output files.
The output files are determined by the YAML front-matter of
standalone Quarto documents and \verb{_quarto.yml} in Quarto projects,
and you can see these files with \code{\link[=tar_quarto_files]{tar_quarto_files()}}
(powered by \code{quarto::quarto_inspect()}).
All returned paths are \emph{relative} paths to ensure portability
(so that the project can be moved from one file system to another
without invalidating the target).
See the "Target objects" section for background.
}
\description{
Shorthand to include a Quarto project in a
\code{targets} pipeline.

\code{\link[=tar_quarto]{tar_quarto()}} expects an unevaluated symbol for the \code{name}
argument and an unevaluated expression for the \code{execute_params} argument.
\code{\link[=tar_quarto_raw]{tar_quarto_raw()}} expects a character string for the \code{name}
argument and an evaluated expression object
for the \code{execute_params} argument.
}
\details{
\code{tar_quarto()} is an alternative to \code{tar_target()} for
Quarto projects and standalone Quarto source documents
that depend on upstream targets. The Quarto
R source documents (\verb{*.qmd} and \verb{*.Rmd} files)
should mention dependency targets with \code{tar_load()} and \code{tar_read()}
in the active R code chunks (which also allows you to render the project
outside the pipeline if the \verb{_targets/} data store already exists).
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
Then, \code{tar_quarto()} defines a special kind of target. It
1. Finds all the \code{tar_load()}/\code{tar_read()} dependencies in the
R source reports and inserts them into the target's command.
This enforces the proper dependency relationships.
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
2. Sets \code{format = "file"} (see \code{tar_target()}) so \code{targets}
watches the files at the returned paths and reruns the report
if those files change.
3. Configures the target's command to return both the output
rendered files and the input dependency files (such as
Quarto source documents). All these file paths
are relative paths so the project stays portable.
4. Forces the report to run in the user's current working directory
instead of the working directory of the report.
5. Sets convenient default options such as \code{deployment = "main"}
in the target and \code{quiet = TRUE} in \code{quarto::quarto_render()}.
}
\section{Quarto troubleshooting}{

If you encounter difficult errors, please read
\url{https://github.com/quarto-dev/quarto-r/issues/16}.
In addition, please try to reproduce the error using
\code{quarto::quarto_render("your_report.qmd", execute_dir = getwd())}
without using \code{targets} at all. Isolating errors this way
makes them much easier to solve.
}

\section{Literate programming limitations}{

Literate programming files are messy and variable,
so functions like \code{\link[=tar_render]{tar_render()}} have limitations:
* Child documents are not tracked for changes.
* Upstream target dependencies are not detected if \code{tar_read()}
and/or \code{tar_load()} are called from a user-defined function.
In addition, single target names must be mentioned and they must
be symbols. \code{tar_load("x")} and \code{tar_load(contains("x"))} may not
detect target \code{x}.
* Special/optional input/output files may not be detected in all cases.
* \code{\link[=tar_render]{tar_render()}} and friends are for local files only. They do not
integrate with the cloud storage capabilities of \code{targets}.
}

\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({  # tar_dir() runs code from a temporary directory.
# Unparameterized Quarto document:
lines <- c(
  "---",
  "title: report.qmd source file",
  "output_format: html",
  "---",
  "Assume these lines are in report.qmd.",
  "```{r}",
  "targets::tar_read(data)",
  "```"
)
writeLines(lines, "report.qmd")
# Include the report in a pipeline as follows.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_target(data, data.frame(x = seq_len(26), y = letters)),
    tar_quarto(name = report, path = "report.qmd")
  )
}, ask = FALSE)
# Then, run the pipeline as usual.

# Parameterized Quarto:
lines <- c(
  "---",
  "title: 'report.qmd source file with parameters'",
  "output_format: html_document",
  "params:",
  "  your_param: \"default value\"",
  "---",
  "Assume these lines are in report.qmd.",
  "```{r}",
  "print(params$your_param)",
  "```"
)
writeLines(lines, "report.qmd")
# Include the report in the pipeline as follows.
unlink("_targets.R") # In tar_dir(), not the user's file space.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_target(data, data.frame(x = seq_len(26), y = letters)),
    tar_quarto(
      name = report,
      path = "report.qmd",
      execute_params = list(your_param = data)
    ),
    tar_quarto_raw(
      name = "report2",
      path = "report.qmd",
      execute_params = quote(list(your_param = data))
    )
  )
}, ask = FALSE)
})
# Then, run the pipeline as usual.
}
}
\seealso{
Other Literate programming targets: 
\code{\link{tar_knit}()},
\code{\link{tar_quarto_rep}()},
\code{\link{tar_render}()},
\code{\link{tar_render_rep}()}
}
\concept{Literate programming targets}
