% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/similarity.R
\docType{methods}
\name{index_sorensen}
\alias{index_sorensen}
\alias{index_sorensen-method}
\alias{index_sorensen,logical,logical-method}
\alias{index_sorensen,numeric,numeric-method}
\title{Dice-Sorensen Qualitative Index}
\usage{
index_sorensen(x, y, ...)

\S4method{index_sorensen}{logical,logical}(x, y)

\S4method{index_sorensen}{numeric,numeric}(x, y)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector.}

\item{...}{Currently not used.}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Dice-Sorensen Qualitative Index
}
\details{
Data are standardized on a presence/absence scale (\eqn{0}/\eqn{1})
beforehand.
}
\references{
Dice, L. R. (1945). Measures of the Amount of Ecologic Association Between
Species. \emph{Ecology}, 26(3): 297-302. \doi{10.2307/1932409}

Sorensen, T. (1948). A Method of Establishing Groups of Equal Amplitude in
Plant Sociology Based on Similarity of Species Content and Its Application
to Analyses of the Vegetation on Danish Commons. \emph{Kongelige Danske
Videnskabernes Selskab}, 5(4): 1-34.
}
\seealso{
Other beta diversity measures: 
\code{\link{index_binomial}()},
\code{\link{index_brainerd}()},
\code{\link{index_bray}()},
\code{\link{index_cody}()},
\code{\link{index_jaccard}()},
\code{\link{index_morisita}()},
\code{\link{index_routledge}},
\code{\link{index_whittaker}()},
\code{\link{index_wilson}()}
}
\author{
N. Frerebeau
}
\concept{beta diversity measures}
