% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_info.R
\name{font_info}
\alias{font_info}
\title{Query font-specific information}
\usage{
font_info(
  family = "",
  italic = FALSE,
  weight = "normal",
  width = "undefined",
  size = 12,
  res = 72,
  path = NULL,
  index = 0,
  variation = font_variation(),
  bold = deprecated()
)
}
\arguments{
\item{family}{The name of the font families to match}

\item{italic}{logical indicating the font slant}

\item{weight}{The weight to query for, either in numbers (\code{0}, \code{100}, \code{200},
\code{300}, \code{400}, \code{500}, \code{600}, \code{700}, \code{800}, or \code{900}) or strings (\code{"undefined"},
\code{"thin"}, \code{"ultralight"}, \code{"light"}, \code{"normal"}, \code{"medium"}, \code{"semibold"},
\code{"bold"}, \code{"ultrabold"}, or \code{"heavy"}). \code{NA} will be interpreted as
\code{"undefined"}/\code{0}}

\item{width}{The width to query for either in numbers (\code{0}, \code{1}, \code{2},
\code{3}, \code{4}, \code{5}, \code{6}, \code{7}, \code{8}, or \code{9}) or strings (\code{"undefined"},
\code{"ultracondensed"}, \code{"extracondensed"}, \code{"condensed"}, \code{"semicondensed"},
\code{"normal"}, \code{"semiexpanded"}, \code{"expanded"}, \code{"extraexpanded"}, or
\code{"ultraexpanded"}). \code{NA} will be interpreted as \code{"undefined"}/\code{0}}

\item{size}{The pointsize of the font to use for size related measures}

\item{res}{The ppi of the size related measures}

\item{path, index}{path and index of a font file to circumvent lookup based on
family and style}

\item{variation}{A \code{font_variation} object or a list of them to control
variable fonts}

\item{bold}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{weight = "bold"} instead}
}
\value{
A data.frame giving info on the requested font + size combinations. The
data.frame will contain the following columns:

\describe{
\item{path}{The path to the font file}
\item{index}{The 0-based index of the font in the fontfile}
\item{family}{The family name of the font}
\item{style}{The style name of the font}
\item{name}{The name of the font, if present, otherwise the family name}
\item{italic}{A logical giving if the font is italic}
\item{bold}{A logical giving if the font is bold}
\item{monospace}{A logical giving if the font is monospace}
\item{weight}{A factor giving the weight of the font}
\item{width}{A factor giving the width of the font}
\item{kerning}{A logical giving if the font supports kerning}
\item{color}{A logical giving if the font has color glyphs}
\item{scalable}{A logical giving if the font is scalable}
\item{vertical}{A logical giving if the font is vertical}
\item{n_glyphs}{The number of glyphs in the font}
\item{n_sizes}{The number of predefined sizes in the font}
\item{n_charmaps}{The number of character mappings in the font file}
\item{bbox}{A bounding box large enough to contain any of the glyphs in the font}
\item{max_ascend}{The maximum ascend of the tallest glyph in the font}
\item{max_descent}{The maximum descend of the most descending glyph in the font}
\item{max_advance_width}{The maximum horizontal advance a glyph can make}
\item{max_advance_height}{The maximum vertical advance a glyph can make}
\item{lineheight}{The height of a single line of text in the font}
\item{underline_pos}{The position of a potential underlining segment}
\item{underline_size}{The width the the underline}
}
}
\description{
Get general information about a font, relative to a given size. Size specific
measures will be returned in pixel units. The function is vectorised to the
length of the longest argument.
}
\examples{
font_info('serif')

# Avoid lookup if font file is already known
sans <- match_fonts('sans')
font_info(path = sans$path, index = sans$index)

}
