% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{survival_rates}
\alias{survival_rates}
\title{Compute survival rates by KM estimate for given time points for an
univariate survival analysis}
\usage{
survival_rates(
  result,
  time_points,
  percentage_decimal_places = 1,
  time_precision = 0,
  timespan_unit = c("days", "months", "years")
)
}
\arguments{
\item{result}{The result generated by \code{\link{analyse_survival}}}

\item{time_points}{Time points to compute survival rate at}

\item{percentage_decimal_places, time_precision}{Precision with which to print floating point values in their label form}

\item{timespan_unit}{Unit for time spans: "days", "months" or "years".}
}
\value{
A data frame with time, number at risk, number with event,
survival rate with CI, and time and rate formatted for printing
}
\description{
Compute survival rates by KM estimate for given time points for an
univariate survival analysis
}
