% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{analyse_survival}
\alias{analyse_survival}
\alias{analyze_survival}
\title{Univariate survival analysis}
\usage{
analyse_survival(
  data,
  time_status,
  by,
  by_label_map = NULL,
  by_order_vector = NULL,
  cox_reference_level = NULL,
  p_adjust_method = "none",
  plot_args = list()
)

analyze_survival(
  data,
  time_status,
  by,
  by_label_map = NULL,
  by_order_vector = NULL,
  cox_reference_level = NULL,
  p_adjust_method = "none",
  plot_args = list()
)
}
\arguments{
\item{data}{A data frame containing the time/status information and, if used, the covariate.}

\item{time_status}{A vector of length 2 giving the time and status fields.
It is recommended to use vars() and symbolic column names or code that is tidily-evaluated on \code{data}.
You can also pass a character vector with the column names or a numeric vector with column indices.}

\item{by}{The term by which survival curves will be separated.
Pass \code{NULL} or omit to generate a single curve and only descriptive statistics.
Pass symbolic columns names or code that is tidily-evaluated on \code{data} to generate more than one curve,
and the appropriate statistics to compare the curves. A column name or column index is also possible.
In any case, the parameter will be used to create a factor with appropriate labels.
This factor will appear in all printouts and plots.
You can use \code{by_label_map} and \code{by_order_vector} to rename and reorder this factor.}

\item{by_label_map}{A dictionary (named list or vector) of old->new labels of the factor created using \code{by}.
The factor will be renamed accordingly, and also reordered by the order of the vector.}

\item{by_order_vector}{A vector of the labels of the factor created using \code{by},
after renaming them based on \code{by_label_map} (so specify the "new" level).
The factor will be ordered according to the order of this vector.
It need not contain all elements, only those found will be reorder at the top.}

\item{cox_reference_level}{The result will include a univariate Cox regression. Use this parameter to specify
the level of the factor generated using \code{by} that you want to use a the reference level
(Hazard ratios will be relative to the reference level, which is defined as having hazard ratio 1.0)
Note that the given string applies after all renaming has been done, so specify the "new" level.}

\item{p_adjust_method}{If there are more than two levels in the \code{by} factor,
the result will include the return value of pairwise_survdiff, which performs p adjustment.
You can specify the desired method here.
Note that other p values are not corrected, this is beyond the scope of this method.}

\item{plot_args}{Named list of arguments that will be stored for later use in plotting methods,
such as kaplan_meier_plot. There they will take precedence over arguments given to that method.
This is useful when plotting multiple results with a set of default arguments, of which some
such as title or axis scale differ per-plot.}
}
\value{
An object of class "SurvivalAnalysisResult" and "SurvivalAnalysisUnivariateResult".
   You can use this result as a black box for further functions in this package,
   \code{\link[=format.SurvivalAnalysisUnivariateResult]{format}} or
   \code{\link[=print.SurvivalAnalysisUnivariateResult]{print}} it,
   retrieve information as a data frame via \code{\link{survival_data_frames}} or
   access individual pieces via \code{\link{pluck_survival_analysis}}
}
\description{
Performs survival analysis on right-censored data using a single covariate, or no covariate.
}
\details{
This method builds upon the \code{survival} package and returns a comprehensive result object
for survival analysis containing the survfit, survdiff and coxph results.
A \code{format}/\code{print} method is provided that prints the essential statistics.
Kaplan-Meier plots are readily generated using the \code{\link{kaplan_meier_plot}} or
\code{\link{kaplan_meier_grid}} functions.
}
\examples{
library(magrittr)
library(dplyr)
survival::aml \%>\%
  analyse_survival(vars(time, status), x) \%>\%
  print
}
