% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{rmst}
\alias{rmst}
\title{Restricted mean survival time}
\usage{
rmst(
  x,
  t,
  newdata = NULL,
  newdata0 = NULL,
  wane_period = NULL,
  wane_nt = 10,
  disc_rate = 0,
  method = "gl",
  gl_nodes = 100,
  niter = NULL,
  summ_fns = NULL,
  sample = FALSE
)
}
\arguments{
\item{x}{A fitted model object as returned by \code{\link{survextrap}}}

\item{t}{Vector of times.  The restricted mean survival time up to each one of these times
will be computed.}

\item{newdata}{Data frame of covariate values to compute the output for.
If there are covariates in the model and this is not supplied,
the following default is used:

(a) if the only covariate is one factor variable, then the output is computed
for each level of this factor.

(b) if there are multiple covariates, or any numeric covariates, then the output
is computed at the mean of each numeric covariate in the original data, and at the
baseline level of each factor covariate.

Note: caution is required about how treatment groups (for example)
are stored in your data.  If these are coded as numeric (0/1),
then if \code{newdata} is not specified, only one output will be shown.
This relates to the average value of this numeric variable over
the data, which doesn't correspond to either of the treatment
groups.  To avoid this, a treatment group should be stored as a
factor.}

\item{newdata0}{Data frame of covariate values defining the "untreated" group
for use in treatment waning models. See \code{\link{Survmspline_wane}}.}

\item{wane_period}{Vector of two numbers, defining the time period over which
the hazard is interpolated between the hazard of the "treated" group (taken from \code{newdata})
and the hazard of the "untreated" group (taken from \code{newdata0}).  Optional - if
this is not supplied, then no waning is assumed.}

\item{wane_nt}{Number of intervals defining the piecewise constant approximation
to the hazard during the waning period.}

\item{disc_rate}{Discounting rate used to calculate the discounted mean
or restricted mean survival time, using an exponential discounting function.}

\item{method}{Method of numerical integration to obtain the
restricted mean survival time from the survival function.

The default is \code{method="gl"}, a Gauss-Legendre method with 100
nodes between zero and the maximum of \code{t}.

\code{method="adaptive"} uses the base R \code{integrate} function, which is
much slower, but potentially more robust for badly-behaved
survival functions.}

\item{gl_nodes}{Number of nodes for the Gauss-Legendre method.}

\item{niter}{Number of MCMC iterations to use to compute credible
intervals.  Set to a low value to make this function quicker, at the cost of
some approximation error (which may not be important for plotting or model
development).}

\item{summ_fns}{A list of functions to use to summarise the posterior sample.
This is passed to \code{\link[posterior:summarise_draws]{posterior::summarise_draws}}.
By default this is \code{list(median=median, ~quantile(.x, probs=c(0.025, 0.975)))}.
If the list is named, then the names will be used for the columns of the
output.}

\item{sample}{If \code{TRUE} then an MCMC sample is returned from the posterior
of the output, rather than summary statistics.}
}
\value{
A data frame (tibble) with each row containing posterior summary statistics
for a particular time and covariate value.

Or if \code{sample=TRUE}, an array with dimensions
\code{length(t)}, \code{niter}, \code{nrow(newdata)}, giving the
RMST evaluated at different times, MCMC iterations and covariate
values respectively.
}
\description{
Compute the restricted mean survival time from a model fitted with
\code{\link{survextrap}}.  Defined as the integral of the fitted
survival curve up to a specified time.
}
\examples{
mod <- survextrap(Surv(years, status) ~ rx, data=colons, fit_method="opt")
rmst(mod, t=3, niter=100)
rmst(mod, t=3, summ_fns=list(mean=mean), niter=100)

}
