% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbh_class.R
\docType{class}
\name{GBH-class}
\alias{GBH-class}
\alias{initialize,GBH-method}
\alias{show,GBH-method}
\alias{GBH}
\alias{summary,GBH-method}
\alias{plot,GBH,ANY-method}
\alias{GBH,ANY}
\title{Manage Group Benjamini-Hochberg Outputs}
\usage{
\S4method{initialize}{GBH}(.Object, ...)

\S4method{show}{GBH}(object)

\S4method{summary}{GBH}(object)

\S4method{plot}{GBH,ANY}(x, title = "GBH Adjustment", ...)
}
\arguments{
\item{.Object}{Dummy to initialize S4 class}

\item{...}{Any other arguments are accepted, but they will be ignored.}

\item{object}{A GBH object whose hypotheses we want to summarize.}

\item{x}{A GBH object whose p-values to plot.}

\item{title}{The name added to the top of the plot. Defaults to 'GBH
Adjustment'.}
}
\description{
This defines a class GBH for managing outputs from the Group
Benjamini-Hochberg procedure. This object makes it easy to print, summarize,
and plot the results of the testing procedure.

Prints the entire table of adjusted p-values and their associated FDR
adjusted significance levels, together with the estimated proportions of null
hypotheses, within each group.

Shows results from multiple testing via GBH. Also supplies the estimated
proportion of null hypothesis within each group and a table of counts of
adjusted significance across groups.

Show results of testing hypothesis, sorted according to GBH adjusted
significance, shape coded according to group membership, and color coded
according to pre and post GBH p-value adjustment.
}
\section{Slots}{

\describe{
\item{\code{p.vals}}{Object of class \code{'data.frame'}. Each row corresponds to an
individual hypothesis. The different columns correspond to,
  * hypothesisIndex: The index of the current hypothesis in the
     \code{unadjp} vector
  * hypothesisName: The name of the current hypothesis, from the names of
     the \code{unadjp} vector
  * unadjp: The unadjusted p-values input from \code{unadjp}
  * adjp: The adjusted p-values, after the GBH adjustment.
  * group: The group to which the original hypothesis belonged
  * significance: A code for the significance of each hypothesis}

\item{\code{pi0}}{Object of class \code{'numeric'}. The proportion of null
hypotheses within each group. This is either known a priori or estimated
adaptively from the unadjusted p-values.}

\item{\code{adaptive}}{Object of class \code{'logical'}. An indicator of whether the
proportion \code{pi0} was estimated adaptively from the data or known a
priori.}

\item{\code{alpha}}{Object of class \code{'numeric'}. The level at which the FDR is
controlled, during the GBH procedure.}
}}

\examples{
# These are the unadjusted p-values corresponding to the outcome of some
# multiple testing experiment. The first 500 hypotheses are null and the last
# 1500 are true alternatives.

unadjp <- c(runif(500, 0, 0.01), runif(1500, 0, 1))
names(unadjp) <- paste('Hyp: ', 1:2000)

# These are the unadjusted p-values corresponding to the outcome of some
# multiple testing experiment. The first 500 hypotheses are null and the last
# 1500 are true alternatives.
unadjp <- c(runif(500, 0, 0.01), runif(1500, 0, 1))
names(unadjp) <- paste('Hyp: ', 1:2000)

# Here there are two groups total we have randomly assigned hypotheses to these
# two groups.
group.index <- c(sample(1:2, 2000, replace = TRUE))

# Perform the GBH adjustment.
result <-  Adaptive.GBH(unadjp, group.index, method = 'storey')

# A summary of the GBH adjustment
summary(result)
}
