% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_collection.R
\docType{class}
\name{Collection}
\alias{Collection}
\title{R6 class representing a collection of LTO thematically annotated stories}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

The \pkg{stoRy} package uses the \code{Collection} R6 class to represent a set
of related LTO thematically annotated stories. This class is mostly useful
for accessing information about a collection of stories for which the
collection ID is known in advance.
}
\details{
The class operates on the story collection of whichever LTO version happens
to be actively loaded into the \pkg{stoRy} package level environment. This
is the LTO \code{demo} version by default. Run \code{\link[=which_lto]{which_lto()}} to check which LTO
version is active in your R session.

Search the latest LTO \code{dev} version collections on the Theme Ontology
website at \url{https://www.themeontology.org/stories}.

Alternatively, it is possible to read in a user-defined collection from
file. In this case, the collection ID as defined in the file must match the
\code{collection_id} input parameter.
}
\examples{
\dontrun{
# Initialize a collection:
set_lto("demo")
collection <- Collection$new(collection_id = "Collection: tvseries: The Twilight Zone (1959)")

# Print collection info to console:
collection

# Print collection info in canonical st.txt format:
collection$print(canonical = TRUE)

# Initialize a collection from file:
set_lto("demo")
file <- system.file("extdata/rolling-stone-best-ttz1959-episodes.st.txt", package = "stoRy")
collection_id <- "Collection: Rolling Stone 25 Best Twilight Zone Original Series Episodes"
collection <- Collection$new(collection_id, file)
collection

# Initialize a collection from a string:
set_lto("demo")
file <- I("Collection: Rolling Stone 25 Best Twilight Zone Original Series Episodes
========================================================================

:: Title
Rolling Stone 25 Best Twilight Zone Original Series Episodes

:: Date
1959-1964

:: Description
Rolling Stone Magazine's list of the 25 best episodes from the original
Twilight Zone anthology television series, which ran for five seasons on CBS
from 1959 to 1964, as compiled by David Fear, Sean T. Collins, and Angie
Martoccio.

:: References
https://www.rollingstone.com/tv/tv-features/25-best-twilight-zone-episodes-list-812043/

:: Collections
Collection: Rolling Stone 25 Best Twilight Zone Original Series Episodes

:: Component Stories
tz1959e3x24
tz1959e1x22
tz1959e2x06
tz1959e5x03
tz1959e2x15
tz1959e2x28
tz1959e1x08
tz1959e3x14
tz1959e3x05
tz1959e5x06
tz1959e3x08
tz1959e1x01
tz1959e1x21
tz1959e1x34
tz1959e2x07
tz1959e1x13
tz1959e1x09
tz1959e3x10
tz1959e1x16
tz1959e1x28
tz1959e1x30
tz1959e3x33
tz1959e3x01
tz1959e2x22
tz1959e5x25")
collection_id <- unlist(strsplit(file, split = "\n"))[1]
collection <- Collection$new(collection_id, file)
collection
}
}
\seealso{
Use \code{\link[=Story]{Story()}} to initialize an LTO thematically annotated story.

Use \code{\link[=Theme]{Theme()}} to initialize an LTO theme.

Use \code{\link[=Themeset]{Themeset()}} to initialize a set of related LTO themes.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Collection-new}{\code{Collection$new()}}
\item \href{#method-Collection-collection_id}{\code{Collection$collection_id()}}
\item \href{#method-Collection-title}{\code{Collection$title()}}
\item \href{#method-Collection-description}{\code{Collection$description()}}
\item \href{#method-Collection-date}{\code{Collection$date()}}
\item \href{#method-Collection-references}{\code{Collection$references()}}
\item \href{#method-Collection-component_story_ids}{\code{Collection$component_story_ids()}}
\item \href{#method-Collection-themes}{\code{Collection$themes()}}
\item \href{#method-Collection-source}{\code{Collection$source()}}
\item \href{#method-Collection-size}{\code{Collection$size()}}
\item \href{#method-Collection-obj_internal_tbl}{\code{Collection$obj_internal_tbl()}}
\item \href{#method-Collection-print}{\code{Collection$print()}}
\item \href{#method-Collection-clone}{\code{Collection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-new"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-new}{}}}
\subsection{Method \code{new()}}{
Initialize a collection of LTO thematically annotated stories.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$new(collection_id, file = NULL, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collection_id}}{A length-one character vector corresponding to the
ID of an LTO collection of stories.}

\item{\code{file}}{A file name of a collection file or path to a collection
file or a string. Files must end with the standard .st.txt extension
used for story and collection files.

If \code{file} is a file name, then the file is assumed to reside in the
current working directory.}

\item{\code{verbose}}{A logical value indicating whether status messages should be
output to console.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Collection} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-collection_id"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-collection_id}{}}}
\subsection{Method \code{collection_id()}}{
return A length-one character vector corresponding to the collection
ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$collection_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-title"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-title}{}}}
\subsection{Method \code{title()}}{
return A length-one character vector corresponding to the collection
title.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$title()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-description"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-description}{}}}
\subsection{Method \code{description()}}{
return A length-one character vector of collection defining text.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$description()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-date"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-date}{}}}
\subsection{Method \code{date()}}{
return A length-one character vector typically of the form "yyyy-yyyy"
indicating the start and end year for stories in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$date()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-references"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-references}{}}}
\subsection{Method \code{references()}}{
return A tibble of collection reference urls, if any.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$references()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-component_story_ids"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-component_story_ids}{}}}
\subsection{Method \code{component_story_ids()}}{
return A tibble of member story IDs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$component_story_ids()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-themes"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-themes}{}}}
\subsection{Method \code{themes()}}{
return A tibble of thematic annotations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$themes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-source"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-source}{}}}
\subsection{Method \code{source()}}{
return The path of the st.txt collection file. This is the file path as
it occurs on the Theme Ontology GitHub repository at
\url{https://github.com/theme-ontology/theming}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$source()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-size"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-size}{}}}
\subsection{Method \code{size()}}{
return A length-one numeric vector containing the number of stories in
the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$size()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-obj_internal_tbl"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-obj_internal_tbl}{}}}
\subsection{Method \code{obj_internal_tbl()}}{
return A special tibble that is used internally by package functions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$obj_internal_tbl()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-print"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-print}{}}}
\subsection{Method \code{print()}}{
Print collection object info to console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$print(canonical = FALSE, n = NULL, width = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{canonical}}{Set to FALSE for pretty output.}

\item{\code{n}}{Maximum number of component story IDs to print to console.
This defaults to NULL which means the
\code{stoRy_opt("print_min")} value is used. Run
\code{options(stoRy.print_min = 25L)} to set the minimum number of
printed component story IDs to be 25. Run
\code{stoRy_opt("print_max")} to check the maximum number of stories
that can be printed to console. This value can be changed in the same
way as with \code{stoRy.print_min}.}

\item{\code{width}}{Width of text output to generate. This defaults to NULL,
which means the \code{stoRy_opt("width")} value is used. Run
\code{options(stoRy.width = 120L)} to change the column width to be 120
characters, etc.}

\item{\code{...}}{Additional arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
