% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isGGIRoutput.R
\name{isGGIRoutput}
\alias{isGGIRoutput}
\title{Check if a directory is a valid GGIR output folder for stepmetrics}
\usage{
isGGIRoutput(path)
}
\arguments{
\item{path}{Character. Path to the directory to be tested.}
}
\value{
Logical scalar. Returns \code{TRUE} if the directory appears to be
  valid GGIR output suitable for stepmetrics, otherwise \code{FALSE}.
}
\description{
Determines whether a given directory corresponds to a valid GGIR output
directory that can be used with \pkg{stepmetrics}. Several conditions
are checked in sequence:
\enumerate{
  \item Path exists and is a directory.
  \item Directory name begins with `"output_"`.
  \item Contains a `meta/` subfolder.
  \item Contains a `meta/ms2.out/` subfolder (GGIR part 2 milestone data).
  \item Contains at least one `*.RData` file in `ms2.out`.
  \item The loaded object \code{IMP$metashort} includes a step column
        (with `"step"` in its name).
}

If any of these checks fail, the function returns \code{FALSE} and issues a
warning describing the missing requirement.
}
\note{
- A warning is issued if the directory looks like GGIR output but is missing
  required parts (e.g., part 2 milestone data or step counts in
  \code{IMP$metashort}).
- This function loads the first available RData file in
  \code{meta/ms2.out/} to verify the presence of step counts.
}
\examples{
\dontrun{
# GGIR output folder
ggir_output_dir = system.file("extdata", "testfiles_GGIR", "output_test", package = "stepmetrics")
isGGIRoutput(ggir_output_dir)

# Non-GGIR directory
isGGIRoutput("C:/mystudy/rawdata/")
}

}
\seealso{
[step.metrics()]
}
