% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr-test.R
\name{corr_test}
\alias{corr_test}
\title{Correlation analyses}
\usage{
corr_test(
  data,
  x,
  y,
  type = "parametric",
  digits = 2L,
  conf.level = 0.95,
  tr = 0.2,
  bf.prior = 0.707,
  ...
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{x}{The column in \code{data} containing the explanatory variable to be
plotted on the \code{x}-axis.}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{conf.level}{Scalar between \code{0} and \code{1} (default: \verb{95\%}
confidence/credible intervals, \code{0.95}). If \code{NULL}, no confidence intervals
will be computed.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of \code{1/2}, \code{sqrt(2)/2}, and \code{1}, respectively. In case of an ANOVA, this
value corresponds to scale for fixed effects.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
The returned tibble data frame can contain some or all of the following columns (the exact columns will depend on the statistical test):
\itemize{
\item \code{statistic}: the numeric value of a statistic
\item \code{df}: the numeric value of a parameter being modeled (often degrees
of freedom for the test)
\item \code{df.error} and \code{df}: relevant only if the statistic in question has
two degrees of freedom (e.g. anova)
\item \code{p.value}: the two-sided \emph{p}-value associated with the observed statistic
\item \code{method}: the name of the inferential statistical test
\item \code{estimate}: estimated value of the effect size
\item \code{conf.low}: lower bound for the effect size estimate
\item \code{conf.high}: upper bound for the effect size estimate
\item \code{conf.level}: width of the confidence interval
\item \code{conf.method}: method used to compute confidence interval
\item \code{conf.distribution}: statistical distribution for the effect
\item \code{effectsize}: the name of the effect size
\item \code{n.obs}: number of observations
\item \code{expression}: pre-formatted expression containing statistical details
}

For examples, see \href{https://indrajeetpatil.github.io/statsExpressions/articles/web_only/dataframe_outputs.html}{data frame output vignette}.
}
\description{
Parametric, non-parametric, robust, and Bayesian correlation test.
}
\section{Correlation analyses}{


The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}

\strong{Hypothesis testing} and \strong{Effect size estimation}\tabular{llll}{
   Type \tab Test \tab CI available? \tab Function used \cr
   Parametric \tab Pearson's correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Non-parametric \tab Spearman's rank correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Robust \tab Winsorized Pearson's correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
   Bayesian \tab Bayesian Pearson's correlation coefficient \tab Yes \tab \code{correlation::correlation()} \cr
}
}

\section{Citation}{
Patil, I., (2021). statsExpressions: R Package for Tidy Dataframes and Expressions with Statistical Details. Journal of Open Source Software, 6(61), 3236, https://doi.org/10.21105/joss.03236
}

\examples{
# for reproducibility
set.seed(123)

# ----------------------- parametric -----------------------

corr_test(mtcars, wt, mpg, type = "parametric")

# ----------------------- non-parametric -------------------

corr_test(mtcars, wt, mpg, type = "nonparametric")

# ----------------------- robust ---------------------------

corr_test(mtcars, wt, mpg, type = "robust")

# ----------------------- Bayesian -------------------------

corr_test(mtcars, wt, mpg, type = "bayes")
}
