/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import java.util.Arrays;

public class IntList {
    public static final int DEFAULT_INIT_CAPACITY = 10;
    private int size;
    private int[] values;

    public IntList() {
        this(10);
    }

    public IntList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.size = 0;
        this.values = new int[n];
    }

    public int get(int n) {
        if (n < 0 && n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.values[n];
    }

    public int set(int n, int n2) {
        if (n < 0 && n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n3 = this.values[n];
        this.values[n] = n2;
        return n3;
    }

    public int getAndIncrement(int n) {
        if (n < 0 && n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        int n3 = this.values[n2];
        this.values[n2] = n3 + 1;
        return n3;
    }

    public int getAndDecrement(int n) {
        if (n < 0 && n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        int n3 = this.values[n2];
        this.values[n2] = n3 - 1;
        return n3;
    }

    public int incrementAndGet(int n) {
        if (n < 0 && n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        int n3 = this.values[n2] + 1;
        this.values[n2] = n3;
        return n3;
    }

    public int decrementAndGet(int n) {
        if (n < 0 && n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int n2 = n;
        int n3 = this.values[n2] - 1;
        this.values[n2] = n3;
        return n3;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.values, this.size);
    }

    public void add(int n) {
        if (this.size == this.values.length) {
            int n2 = this.values.length * 3 / 2 + 1;
            this.values = Arrays.copyOf(this.values, n2);
        }
        this.values[this.size++] = n;
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

