% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSbetafun.R
\name{SSbeta}
\alias{SSbeta}
\alias{beta.fun}
\alias{NLS.beta}
\alias{DRC.beta}
\title{Beta equation}
\usage{
beta.fun(X, b, d, Xb, Xo, Xc)
NLS.beta(X, b, d, Xb, Xo, Xc)
DRC.beta()
}
\arguments{
\item{X}{a numeric vector of values at which to evaluate the model}

\item{b}{model parameter}

\item{d}{model parameter}

\item{Xb}{model parameter (base threshold level)}

\item{Xo}{model parameter (optimal threshold level)}

\item{Xc}{model parameter (ceiling threshold level)}
}
\value{
beta.fun, NLS.beta return a numeric value,
while DRC.beta returns a list containing the nonlinear function
and the self starter function
}
\description{
These functions provide the beta equation, a threshold model that was derived
from the beta density function and it was adapted to describe phenomena taking place only
within a minimum and a maximum threshold value (threshold model), for example
to describe the germination rate (GR, i.e. the inverse of germination time)
as a function of temperature. These functions provide the beta
equation (beta.fun), the self-starters for the \code{\link{nls}}
function (NLS.beta) and the self-starters for
the \code{\link[drc]{drm}} function in the drc package (DRC.beta)
}
\details{
This equation is parameterised as:

\deqn{ f(x) = max\left( d \left\{ \left( \frac{X - Xb}{Xo - Xb} \right) \left( \frac{Xc - X}{Xc - Xo} \right) ^{\frac{Xc - Xo}{Xo - Xb}} \right\}^b , 0 \right)}

It depicts a curve that is equal to 0 for X < Xb, grows up to a maximum,
that is attained at X = Xo and decreases down to 0, that is attained at
X = Xc and mantained for X > Xc.
}
\examples{
X <- c(1, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50)
Y <- c(0, 0, 0, 7.7, 12.3, 19.7, 22.4, 20.3, 6.6, 0, 0)

model <- nls(Y ~ NLS.beta(X, b, d, Xb, Xo, Xc))
summary(model)
modelb <- drm(Y ~ X, fct = DRC.beta())
summary(modelb)
plot(modelb, log = "")
}
\references{
Ratkowsky, DA (1990) Handbook of nonlinear regression models. New York (USA): Marcel Dekker Inc.

Onofri, A. (2020). A collection of self-starters for nonlinear regression in R. See: \url{https://www.statforbiology.com/2020/stat_nls_usefulfunctions/}
}
\author{
Andrea Onofri
}
