% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateParams.R
\name{random_impactmat}
\alias{random_impactmat}
\title{Create random VAR model impact matrix}
\usage{
random_impactmat(d, B_scale, is_regime1 = TRUE)
}
\arguments{
\item{B_scale}{a size \eqn{(d \times 1)} strictly positive vector specifying the mean and variability of the
random impact matrices in random mutations. In Regime 1, the mean of the error term covariance matrix
implied by the random impact matrix will be \code{0.95*diag(B_scale)} and in the rest of the regimes \code{diag(B_scale)},
whereas the variability increases with \code{B_scale}.
Default in \code{GAfit} is \code{var(stats::ar(data[,i], order.max=10)$resid, na.rm=TRUE), i=1,...,d}.
This argument is ignored if \code{cond_dist != "ind_Student"}.}

\item{is_regime1}{is the impact matrix for Regime 1? Regime 1 impact matrix is constrained so the elements
in its first row are in a decreasing ordering and the diagonal elements are strictly positive.}
}
\value{
Returns a \eqn{(d^2 \times 1)} vector containing the vectorized impact matrix \eqn{B}.
}
\description{
\code{random_impactmat} generates random VAR model \eqn{(dxd)} impact matrix \eqn{B}
  with its elements drawn from specific normal distributions (see the source code). If not the first
  regime, will create the matrix \eqn{B_m*}.
}
\details{
If the impact matrix is not for Regime 1, will create the matrix \eqn{B_m*}, which is related
  to the impact matrix \eqn{B_m} of Regime m as \eqn{B_m* = B_m - B_1}.
}
\keyword{internal}
