
<!-- README.md is generated from README.Rmd. Please edit that file -->

# spectre <img src='man/figures/spectre.png' align="right" width="150" /></a>

<!-- badges: start -->

| Development | CI | CRAN | License |
|----|----|----|----|
| [![Project Status](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active) | [![R-CMD-check](https://github.com/r-spatialecology/spectre/actions/workflows/r-cmd-check.yml/badge.svg)](https://github.com/r-spatialecology/spectre/actions/workflows/r-cmd-check.yml) | [![CRAN status](https://www.r-pkg.org/badges/version/spectre)](https://CRAN.R-project.org/package=spectre) | [![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0) |
| [![Lifecycle: stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable) | [![Codecov test coverage](https://codecov.io/gh/r-spatialecology/spectre/graph/badge.svg)](https://app.codecov.io/gh/r-spatialecology/spectre) | [![CRAN logs](https://cranlogs.r-pkg.org/badges/grand-total/spectre)](https://CRAN.R-project.org/package=spectre) | [![DOI](https://img.shields.io/badge/DOI-10.1111/ecog.06272-blue.svg)](https://doi.org/10.1111/ecog.06272) |

<!-- badges: end -->

The goal of `spectre` is to provide an open source tool capable of
predicting regional community composition at fine spatial resolutions
using only sparse biological and environmental data.

## Installation

Install the release version from CRAN:

``` r
install.packages("spectre")
```

To install the developmental version of `spectre`, use:

``` r
install.packages("remotes")
remotes::install_github("r-spatialecology/spectre")
```

A full use case example is included in the “Getting started with
spectre” vignette associated with the package.

## Meta

- Please [report any issues or
  bugs](https://github.com/r-spatialecology/spectre/issues/new).
- Get citation information for `spectre` in R doing
  `citation(package = 'spectre')`

## Code of Conduct

Please note that the **spectre** package is released with a Contributor
Code of Conduct. By contributing to this project, you agree to abide by
its terms.

To see how to contribute to this project, please see the Contributing
guidelines.
