% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{xlof}
\alias{xlof}
\title{Flags suspicious using the local outlier factor or Density-Based Spatial Clustering of Applications with Noise.}
\usage{
xlof(
  data,
  output,
  minPts,
  exclude = NULL,
  metric = "manhattan",
  mode = "soft",
  pc = FALSE,
  boot = FALSE,
  var,
  pcvar = NULL
)
}
\arguments{
\item{data}{Data frame of species records with environmental data}

\item{output}{Either clean: for data frame with no suspicious outliers or outlier: to return dataframe with only outliers.}

\item{minPts}{Minimum neighbors around the records.}

\item{exclude}{Exclude variables that should not be considered in the fitting the one class model, for example x and y columns or
latitude/longitude or any column that the user doesn't want to consider.}

\item{metric}{Distance-based measure to examine the distance between variables. Default \code{manhattan}.}

\item{mode}{Either \code{soft} if mean is used or \code{robust} if mad is used. Default \code{soft}.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}

\item{var}{The variable of concern, which is vital for univariate outlier detection methods}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}
}
\value{
Dataframe with or with no outliers.
}
\description{
Flags suspicious using the local outlier factor or Density-Based Spatial Clustering of Applications with Noise.
}
\examples{

\donttest{
data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                       lat = 'decimalLatitude',
                       lon= 'decimalLongitude',
                       colsp = "scientificName",
                      bbox = db,
                       minpts = 10)

lofout <- xlof(data = refdata[["Thymallus thymallus"]], exclude = c("x", "y"),
                output='outlier', metric ='manhattan',
                minPts = 10, mode = "soft")
}

}
