% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_write_table}
\alias{stream_write_table}
\title{Write Stream to Table}
\usage{
stream_write_table(
  x,
  path,
  format = NULL,
  mode = c("append", "complete", "update"),
  checkpoint = file.path("checkpoints", random_string("")),
  options = list(),
  partition_by = NULL,
  ...
)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{format}{Specifies format of data written to table E.g.
\code{"delta"}, \code{"parquet"}. Defaults to \code{NULL} which will use
system default format.}

\item{mode}{Specifies how data is written to a streaming sink. Valid values are
\code{"append"}, \code{"complete"} or \code{"update"}.}

\item{checkpoint}{The location where the system will write all the checkpoint
information to guarantee end-to-end fault-tolerance.}

\item{options}{A list of strings with additional options.}

\item{partition_by}{Partitions the output by the given list of columns.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Writes a Spark dataframe stream into a table.
}
\seealso{
Other Spark stream serialization: 
\code{\link{stream_write_csv}()},
\code{\link{stream_write_memory}()}
}
\concept{Spark stream serialization}
