% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_write_csv}
\alias{spark_write_csv}
\title{Write a Spark DataFrame to a CSV}
\usage{
spark_write_csv(
  x,
  path,
  header = TRUE,
  delimiter = ",",
  quote = "\\"",
  escape = "\\\\",
  charset = "UTF-8",
  null_value = NULL,
  options = list(),
  mode = NULL,
  partition_by = NULL,
  ...
)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{header}{Should the first row of data be used as a header? Defaults to \code{TRUE}.}

\item{delimiter}{The character used to delimit each column, defaults to \code{,}.}

\item{quote}{The character used as a quote. Defaults to \samp{'"'}.}

\item{escape}{The character used to escape other characters, defaults to \code{\\}.}

\item{charset}{The character set, defaults to \code{"UTF-8"}.}

\item{null_value}{The character to use for default values, defaults to \code{NULL}.}

\item{options}{A list of strings with additional options.}

\item{mode}{A \code{character} element. Specifies the behavior when data or
  table already exists. Supported values include: 'error', 'append', 'overwrite' and
  ignore. Notice that 'overwrite' will also change the column structure.

  For more details see also \url{https://spark.apache.org/docs/latest/sql-programming-guide.html#save-modes}
  for your version of Spark.}

\item{partition_by}{A \code{character} vector. Partitions the output by the given columns on the file system.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Write a Spark DataFrame to a tabular (typically, comma-separated) file.
}
\seealso{
Other Spark serialization routines: 
\code{\link{collect_from_rds}()},
\code{\link{spark_insert_table}()},
\code{\link{spark_load_table}()},
\code{\link{spark_read}()},
\code{\link{spark_read_avro}()},
\code{\link{spark_read_binary}()},
\code{\link{spark_read_csv}()},
\code{\link{spark_read_delta}()},
\code{\link{spark_read_image}()},
\code{\link{spark_read_jdbc}()},
\code{\link{spark_read_json}()},
\code{\link{spark_read_libsvm}()},
\code{\link{spark_read_orc}()},
\code{\link{spark_read_parquet}()},
\code{\link{spark_read_source}()},
\code{\link{spark_read_table}()},
\code{\link{spark_read_text}()},
\code{\link{spark_save_table}()},
\code{\link{spark_write_avro}()},
\code{\link{spark_write_delta}()},
\code{\link{spark_write_jdbc}()},
\code{\link{spark_write_json}()},
\code{\link{spark_write_orc}()},
\code{\link{spark_write_parquet}()},
\code{\link{spark_write_source}()},
\code{\link{spark_write_table}()},
\code{\link{spark_write_text}()}
}
\concept{Spark serialization routines}
