% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NEW_k_functions_sf.R
\name{prep_kfuncs_results}
\alias{prep_kfuncs_results}
\title{Preparing results for K functions}
\usage{
prep_kfuncs_results(
  k_vals,
  g_vals,
  all_values,
  conf_int,
  calc_g_func,
  cross,
  dist_seq,
  return_sims
)
}
\arguments{
\item{k_vals}{a numeric vector with the real K values}

\item{g_vals}{a numeric vector with the real g values}

\item{all_values}{a list with the simulated K and G values that must be arranged.}

\item{conf_int}{the confidence interval parameter.}

\item{calc_g_func}{a boolean indicating if the G function has been calculated.}

\item{cross}{a boolean indicating if we have calculated a simple (FALSE) or a cross function.}

\item{dist_seq}{a numeric vector representing the distance used for calculation}

\item{return_sims}{a boolean, indicating if the simulations must be returned}
}
\value{
A list with the following values :
\itemize{
\item plotk: A ggplot2 object representing the values of the k-function
\item plotg: A ggplot2 object representing the values of the g-function
\item values: A DataFrame with the values used to build the plots
}
}
\description{
Prepare the final results at the end of the execution of the main
functions calculating K or G functions.
}
\examples{
# no example, this is an internal function
}
\keyword{internal}
