% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{pDistr}
\alias{pDistr}
\title{Proportion of total}
\usage{
pDistr(x, quantiles)
}
\arguments{
\item{x}{numeric vector of non-negative real numbers}

\item{quantiles}{quantiles of the cumulative distribution}
}
\description{
Internal soundgen function.
}
\details{
Calculates the values in the input distribution that contain particular
proportions of the sum of all values in the input distribution.
}
\examples{
x = rnorm(100)
x = x - min(x)  # must be non-negative
hist(x)
v = soundgen:::pDistr(x, quantiles = c(.5, .8, .9))
sum(x[x > v['0.5']]) / sum(x)
sum(x[x > v['0.9']]) / sum(x)
}
\keyword{internal}
