% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralDescr.R
\name{getHNR}
\alias{getHNR}
\title{Get HNR}
\usage{
getHNR(
  x = NULL,
  samplingRate = NA,
  acf_x = NULL,
  lag.min = 2,
  lag.max = length(x),
  interpol = c("none", "parab", "spline", "sinc")[4],
  wn = "hanning",
  idx_max = NULL
)
}
\arguments{
\item{x}{time series (a numeric vector)}

\item{samplingRate}{sampling rate}

\item{acf_x}{pre-computed autocorrelation function of input \code{x}, if
already available}

\item{lag.min, lag.max}{minimum and maximum lag to consider when looking for
peaks in the ACF; lag.min = samplingRate/pitchCeiling, lag.max =
samplingRate/pitchFloor}

\item{interpol}{method of improving the frequency resolution by interpolating
the ACF: "none" = don't interpolate; "parab" = parabolic interpolation on
three points (local peak and its neighbors); "spline" = spline
interpolation; "sinc" = sin(x)/x interpolation to a continuous function
followed by a search for local peaks using Brent's method}

\item{wn}{window applied to \code{x} (unless acf_x is provided instead of x)
as well as to the sinc interpolation}

\item{idx_max}{(internal) the index of the peak to investigate, if already
estimated}
}
\value{
A list of three components: f0 = frequency corresponding to the peak
  of the autocorrelation function; max_acf = amplitude of the peak of the
  autocorrelation function on a scale of (0, 1); HNR = 10 * log10(x / (1 -
  max_acf)).
}
\description{
Calculates the harmonics-to-noise ratio (HNR) - that is, the ratio between
the intensity (root mean square amplitude) of the harmonic component and the
intensity of the noise component. Normally called by \code{\link{analyze}}.
}
\examples{
signal = sin(2 * pi * 150 * (1:16000)/16000)
signal = signal / sqrt(mean(signal^2))
noise = rnorm(16000)
noise = noise / sqrt(mean(noise^2))
SNR = 40
s = signal + noise * 10^(-SNR/20)
soundgen:::getHNR(s, 16000, lag.min = 16000/1000,
lag.max = 16000/75, interpol = 'none')
soundgen:::getHNR(s, 16000, lag.min = 16000/1000,
lag.max = 16000/75, interpol = 'parab')
soundgen:::getHNR(s, 16000, lag.min = 16000/1000,
lag.max = 16000/75, interpol = 'spline')
soundgen:::getHNR(s, 16000, lag.min = 16000/1000,
lag.max = 16000/75, interpol = 'sinc')
}
\references{
Boersma, P. (1993). Accurate short-term analysis of the
  fundamental frequency and the harmonics-to-noise ratio of a sampled sound.
  In Proceedings of the institute of phonetic sciences (Vol. 17, No. 1193,
  pp. 97-110).
}
