% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanics.R
\name{obliquity}
\alias{obliquity}
\title{Computes obliquity of the ecliptic}
\usage{
obliquity(year = skyscapeR.env$cur.year)
}
\arguments{
\item{year}{Year for which to calculate the obliquity.
Defaults to present year as given by \emph{Sys.Date}}
}
\description{
This function calculates the obliquity for a given epoch. It is a
wrapper for function \code{\link[swephR]{swe_calc_ut}} of package \emph{swephR}.
}
\examples{
#' # Obliquity for year 3999 BC:
obliquity(-4000)
}
\references{
Laskar, J. et al. (2004), A long-term numerical
solution for the insolation quantities of the Earth, \emph{Astron.
 Astroph.}, 428, 261-285, doi:10.1051/0004-6361:20041335.
}
\seealso{
\code{\link[swephR]{swe_calc_ut}}
}
