% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_power_curves.R
\name{calculate_power_curves}
\alias{calculate_power_curves}
\title{Calculate Power Curves}
\usage{
calculate_power_curves(
  trials,
  effectsize = 1,
  candidateset = NULL,
  model = NULL,
  alpha = 0.05,
  gen_args = list(),
  eval_function = "eval_design",
  eval_args = list(),
  random_seed = 123,
  iterate_seed = FALSE,
  plot_results = TRUE,
  auto_scale = TRUE,
  x_breaks = NULL,
  y_breaks = seq(0, 1, by = 0.1),
  ggplot_elements = list()
)
}
\arguments{
\item{trials}{A numeric vector indicating the trial(s) used when computing the power curve. If a single
value, this will be fixed and only \code{effectsize} will be varied.}

\item{effectsize}{Default \code{1}. A numeric vector indicating the effect size(s) used when computing the power curve. If a single
value, this will be fixed and only \code{trials} will be varied. If using a length-2 effect size with \code{\link[=eval_design_mc]{eval_design_mc()}} (such as
a binomial probability interval), the effect size pairs can be input as entries in a list.}

\item{candidateset}{Default \code{NULL}. The candidate set (see \code{\link[=gen_design]{gen_design()}} documentation for more information). Provided to aid code completion: can also
be provided in \code{gen_args}.}

\item{model}{Default \code{NULL}. The model (see \code{\link[=gen_design]{gen_design()}} and \code{\link[=eval_design]{eval_design()}} documentation for more information). Provided to aid code completion: can also
be provided in \code{gen_args}/\code{eval_args}.}

\item{alpha}{Default \code{0.05}. The allowable Type-I error rate (see \code{\link[=eval_design]{eval_design()}} documentation for more information). Provided to aid code completion: can also
be provided in \code{eval_args}.}

\item{gen_args}{Default \code{list()}. A list of argument/value pairs to specify the design generation parameters for \code{\link[=gen_design]{gen_design()}}.}

\item{eval_function}{Default \code{"eval_design"}. A string (or function) specifying the skpr power evaluation function
(e.g. \code{\link[=eval_design]{eval_design()}}, \code{\link[=eval_design_mc]{eval_design_mc()}}, \code{\link[=eval_design_survival_mc]{eval_design_survival_mc()}}, or \code{\link[=eval_design_custom_mc]{eval_design_custom_mc()}}).}

\item{eval_args}{Default \code{list()}. A list of argument/value pairs to specify the design power evaluation parameters for \code{eval_function}.}

\item{random_seed}{Default \code{123}. The random seed used to generate and then evaluate the design. The seed is set right before design generation.}

\item{iterate_seed}{Default \code{FALSE}. This will iterate the random seed with each new design. Set this to \code{TRUE} to add more variability to the design generation process.}

\item{plot_results}{Default \code{TRUE}. Whether to print out a plot of the power curves in addition to the data frame of results. Requires \code{ggplot2}.}

\item{auto_scale}{Default \code{TRUE}. Whether to automatically scale the y-axis to 0 and 1.}

\item{x_breaks}{Default \code{NULL}, automaticly generated by ggplot2.}

\item{y_breaks}{Default \code{seq(0,1,by=0.1)}. Y-axis breaks.}

\item{ggplot_elements}{Default \code{list()}. Extra \code{ggplot2} elements to customize the plot, passed in as elements in a list.}
}
\value{
A data.frame of power values with design generation information.
}
\description{
Calculate and optionally plot power curves for different effect sizes and
trial counts. This function takes a
}
\examples{
if(skpr:::run_documentation()) {
cand_set = expand.grid(brew_temp = c(80, 85, 90),
                      altitude = c(0, 2000, 4000),
                      bean_sun = c("low", "partial", "high"))
#Plot power for a linear model with all interactions
calculate_power_curves(trials=seq(10,60,by=5),
                      candidateset = cand_set,
                      model = ~.*.,
                      alpha = 0.05,
                      effectsize = 1,
                      eval_function = "eval_design") |>
 head(30)

}
if(skpr:::run_documentation()) {
#Add multiple effect sizes
calculate_power_curves(trials=seq(10,60,by=1),
                      candidateset = cand_set,
                      model = ~.*.,
                      alpha = 0.05,
                      effectsize = c(1,2),
                      eval_function = "eval_design") |>
 head(30)
}
if(skpr:::run_documentation()) {
#Generate power curve for a binomial model
calculate_power_curves(trials=seq(50,150,by=10),
                      candidateset = cand_set,
                      model = ~.,
                      effectsize = c(0.6,0.9),
                      eval_function = "eval_design_mc",
                      eval_args = list(nsim = 100, glmfamily = "binomial")) |>
 head(30)
}
if(skpr:::run_documentation()) {
#Generate power curve for a binomial model and multiple effect sizes
calculate_power_curves(trials=seq(50,150,by=10),
                      candidateset = cand_set,
                      model = ~.,
                      effectsize = list(c(0.5,0.9),c(0.6,0.9)),
                      eval_function = "eval_design_mc",
                      eval_args = list(nsim = 100, glmfamily = "binomial")) |>
 head(30)
}
}
