% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_dptos}
\alias{plot_dptos}
\title{Generar gráfico de distribución de casos por departamentos}
\usage{
plot_dptos(data_agrupada, col_dptos = NULL, fuente_data = NULL)
}
\arguments{
\item{data_agrupada}{Un `data.frame` que contiene los datos de la
enfermedad o evento agrupados por departamentos.}

\item{col_dptos}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene los departamenos en los datos agrupados de la
enfermedad o evento; su valor por defecto es `NULL`.}

\item{fuente_data}{Un `character` (cadena de caracteres) que contiene la
leyenda o fuente de información de los datos; su valor por defecto
es `NULL`.}
}
\value{
Un `plot` o gráfico de distribución de casos por departamentos.
}
\description{
Función que genera el gráfico de distribución de casos por
departamentos.
}
\examples{
\donttest{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(dengue2020)
data_limpia <- estandarizar_geo_cods(data_limpia)
data_agrupada <- agrupar_dpto(data_event = data_limpia)
plot_dptos(data_agrupada,
  col_dptos = "departamento_ocurrencia"
)
}
}
