% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_histogram.R
\name{hist.probs_cube}
\alias{hist.probs_cube}
\title{histogram of prob cubes}
\usage{
\method{hist}{probs_cube}(x, ..., tile = x[["tile"]][[1L]], label = NULL, size = 100000L)
}
\arguments{
\item{x}{Object of classes "raster_cube".}

\item{...}{Further specifications for \link{summary}.}

\item{tile}{Tile to be shown}

\item{label}{Label to be shown}

\item{size}{Number of cells to be sampled}
}
\value{
A histogram of one label of a probability cube.
}
\description{
This is a generic function. Parameters depend on the specific
type of input.
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    modis_cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    probs_cube <- sits_classify(
        data = modis_cube,
        ml_model = rfor_model,
        output_dir = tempdir()
    )
    hist(probs_cube, label = "Forest")
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
