% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{WN}
\alias{WN}
\title{Create an White Noise (WN) Process}
\usage{
WN(sigma2 = NULL)
}
\arguments{
\item{sigma2}{A \code{double} value for the variance, \eqn{\sigma ^2}{sigma^2}, of a WN process.}
}
\value{
An S3 object with called ts.model with the following structure:
\describe{
 \item{process.desc}{Used in summary: "WN"}
 \item{theta}{\eqn{\sigma}{sigma}}
 \item{plength}{Number of Parameters}
 \item{print}{String containing simplified model}
 \item{desc}{y desc replicated x times}
 \item{obj.desc}{Depth of Parameters e.g. list(1)}
 \item{starting}{Guess Starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Sets up the necessary backend for the WN process.
}
\note{
In this process, \eqn{Y_t} is iid from a zero mean normal distribution with variance \eqn{\sigma^2}
}
\examples{
WN()
WN(sigma2=3.4)
}
\author{
James Balamuta
}
