# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Convert Parameters from the Linear Stochastic Differential Equation Model
#' to State Space Model Parameterization
#'
#' This function converts parameters from
#' the linear stochastic differential equation model
#' to state space model parameterization.
#'
#' @details Let the linear stochastic equation model be given by
#'   \deqn{
#'     \mathrm{d}
#'     \boldsymbol{\eta}_{i, t}
#'     =
#'     \left(
#'       \boldsymbol{\iota}
#'       +
#'       \boldsymbol{\Phi}
#'       \boldsymbol{\eta}_{i, t}
#'     \right)
#'     \mathrm{d} t
#'     +
#'     \boldsymbol{\Sigma}^{\frac{1}{2}}
#'     \mathrm{d}
#'     \mathbf{W}_{i, t}
#'   }
#'   for individual \eqn{i} and time \eqn{t}.
#'   The discrete-time state space model
#'   given below
#'   represents the discrete-time solution
#'   for the linear stochastic differential equation.
#'   \deqn{
#'     \boldsymbol{\eta}_{i, t_{{l_{i}}}}
#'     =
#'     \boldsymbol{\alpha}_{\Delta t_{{l_{i}}}}
#'     +
#'     \boldsymbol{\beta}_{\Delta t_{{l_{i}}}}
#'     \boldsymbol{\eta}_{i, t_{l_{i} - 1}}
#'     +
#'     \boldsymbol{\zeta}_{i, t_{{l_{i}}}},
#'     \quad
#'     \mathrm{with}
#'     \quad
#'     \boldsymbol{\zeta}_{i, t_{{l_{i}}}}
#'     \sim
#'     \mathcal{N}
#'     \left(
#'     \mathbf{0},
#'     \boldsymbol{\Psi}_{\Delta t_{{l_{i}}}}
#'     \right)
#'   }
#'   with
#'   \deqn{
#'       \boldsymbol{\beta}_{\Delta t_{{l_{i}}}}
#'       =
#'       \exp{
#'         \left(
#'           \Delta t
#'           \boldsymbol{\Phi}
#'         \right)
#'       },
#'   }
#'
#'   \deqn{
#'       \boldsymbol{\alpha}_{\Delta t_{{l_{i}}}}
#'       =
#'       \boldsymbol{\Phi}^{-1}
#'       \left(
#'         \boldsymbol{\beta} - \mathbf{I}_{p}
#'       \right)
#'       \boldsymbol{\iota}, \quad \mathrm{and}
#'   }
#'
#'   \deqn{
#'       \mathrm{vec}
#'       \left(
#'         \boldsymbol{\Psi}_{\Delta t_{{l_{i}}}}
#'       \right)
#'       =
#'       \left[
#'         \left(
#'           \boldsymbol{\Phi} \otimes \mathbf{I}_{p}
#'         \right)
#'         +
#'         \left(
#'           \mathbf{I}_{p} \otimes \boldsymbol{\Phi}
#'         \right)
#'       \right]
#'       \left[
#'         \exp
#'         \left(
#'           \left[
#'             \left(
#'               \boldsymbol{\Phi} \otimes \mathbf{I}_{p}
#'             \right)
#'             +
#'             \left(
#'               \mathbf{I}_{p} \otimes \boldsymbol{\Phi}
#'             \right)
#'           \right]
#'           \Delta t
#'         \right)
#'         -
#'         \mathbf{I}_{p \times p}
#'       \right]
#'       \mathrm{vec}
#'       \left(
#'         \boldsymbol{\Sigma}
#'       \right)
#'   }
#'   where \eqn{t} denotes continuous-time processes
#'   that can be defined by any arbitrary time point,
#'   \eqn{t_{l_{i}}} the \eqn{l^\mathrm{th}}
#'   observed measurement occassion for individual \eqn{i},
#'   \eqn{p} the number of latent variables and
#'   \eqn{\Delta t} the time interval.
#'
#' @references
#'   Harvey, A. C. (1990).
#'   Forecasting, structural time series models and the Kalman filter.
#'   Cambridge University Press.
#'   \doi{10.1017/cbo9781107049994}
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param iota Numeric vector.
#'   An unobserved term that is constant over time
#'   (\eqn{\boldsymbol{\iota}}).
#' @param phi Numeric matrix.
#'   The drift matrix
#'   which represents the rate of change of the solution
#'   in the absence of any random fluctuations
#'   (\eqn{\boldsymbol{\Phi}}).
#' @param sigma_l Numeric matrix.
#'   Cholesky factorization (`t(chol(sigma))`)
#'   of the covariance matrix of volatility
#'   or randomness in the process
#'   (\eqn{\boldsymbol{\Sigma}}).
#' @param delta_t Numeric.
#'   Time interval
#'   (\eqn{\Delta_t}).
#'
#' @return Returns a list of state space parameters:
#'   - `alpha`: Numeric vector.
#'     Vector of constant values for the dynamic model
#'     (\eqn{\boldsymbol{\alpha}}).
#'   - `beta`: Numeric matrix.
#'     Transition matrix relating the values of the latent variables
#'     from the previous time point to the current time point.
#'     (\eqn{\boldsymbol{\beta}}).
#'   - `psi_l`: Numeric matrix.
#'     Cholesky factorization (`t(chol(psi))`)
#'     of the process noise covariance matrix
#'     \eqn{\boldsymbol{\Psi}}.
#'
#' @examples
#' p <- 2
#' iota <- c(0.317, 0.230)
#' phi <- matrix(
#'   data = c(
#'    -0.10,
#'    0.05,
#'    0.05,
#'    -0.10
#'  ),
#'  nrow = p
#' )
#' sigma <- matrix(
#'   data = c(
#'     2.79,
#'     0.06,
#'     0.06,
#'     3.27
#'   ),
#'   nrow = p
#' )
#' sigma_l <- t(chol(sigma))
#' delta_t <- 0.10
#'
#' LinSDE2SSM(
#'   iota = iota,
#'   phi = phi,
#'   sigma_l = sigma_l,
#'   delta_t = delta_t
#' )
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace transformation linsde
#' @export
LinSDE2SSM <- function(iota, phi, sigma_l, delta_t) {
    .Call(`_simStateSpace_LinSDE2SSM`, iota, phi, sigma_l, delta_t)
}

#' Simulate Transition Matrices
#' from the Multivariate Normal Distribution
#'
#' This function simulates random transition matrices
#' from the multivariate normal distribution.
#' The function ensures that the generated transition matrices are stationary
#' using [TestStationarity()].
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param beta Numeric matrix.
#'   The transition matrix (\eqn{\boldsymbol{\beta}}).
#' @param vcov_beta_vec_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_beta_vec))`)
#'   of the sampling variance-covariance matrix
#'   \eqn{\mathrm{vec} \left( \boldsymbol{\beta} \right)}.
#'
#' @examples
#' n <- 10
#' beta <- matrix(
#'   data = c(
#'     0.7, 0.5, -0.1,
#'     0.0, 0.6, 0.4,
#'     0, 0, 0.5
#'   ),
#'   nrow = 3
#' )
#' vcov_beta_vec_l <- t(chol(0.001 * diag(9)))
#' SimBetaN(n = n, beta = beta, vcov_beta_vec_l = vcov_beta_vec_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimBetaN <- function(n, beta, vcov_beta_vec_l) {
    .Call(`_simStateSpace_SimBetaN`, n, beta, vcov_beta_vec_l)
}

#' Simulate Random Drift Matrices
#' from the Multivariate Normal Distribution
#'
#' This function simulates random drift matrices
#' from the multivariate normal distribution.
#' The function ensures that the generated drift matrices are stable
#' using [TestPhi()].
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param phi Numeric matrix.
#'   The drift matrix (\eqn{\boldsymbol{\Phi}}).
#' @param vcov_phi_vec_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_phi_vec))`)
#'   of the sampling variance-covariance matrix
#'   \eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)}.
#'
#' @examples
#' n <- 10
#' phi <- matrix(
#'   data = c(
#'     -0.357, 0.771, -0.450,
#'     0.0, -0.511, 0.729,
#'     0, 0, -0.693
#'   ),
#'   nrow = 3
#' )
#' vcov_phi_vec_l <- t(chol(0.001 * diag(9)))
#' SimPhiN(n = n, phi = phi, vcov_phi_vec_l = vcov_phi_vec_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace linsde
#' @export
SimPhiN <- function(n, phi, vcov_phi_vec_l) {
    .Call(`_simStateSpace_SimPhiN`, n, phi, vcov_phi_vec_l)
}

.SimSSMFixed0 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l) {
    .Call(`_simStateSpace_SimSSMFixed0`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l)
}

.SimSSMFixed1 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma) {
    .Call(`_simStateSpace_SimSSMFixed1`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma)
}

.SimSSMFixed2 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma, kappa) {
    .Call(`_simStateSpace_SimSSMFixed2`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma, kappa)
}

.SimSSMIVary0 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l) {
    .Call(`_simStateSpace_SimSSMIVary0`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l)
}

.SimSSMIVary1 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma) {
    .Call(`_simStateSpace_SimSSMIVary1`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma)
}

.SimSSMIVary2 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma, kappa) {
    .Call(`_simStateSpace_SimSSMIVary2`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma, kappa)
}

.SimSSMLatFixed0 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l) {
    .Call(`_simStateSpace_SimSSMLatFixed0`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l)
}

.SimSSMLatFixed1 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, x, gamma) {
    .Call(`_simStateSpace_SimSSMLatFixed1`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, x, gamma)
}

.SimSSMLatIVary0 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l) {
    .Call(`_simStateSpace_SimSSMLatIVary0`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l)
}

.SimSSMLatIVary1 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, x, gamma) {
    .Call(`_simStateSpace_SimSSMLatIVary1`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, x, gamma)
}

.SimSSMLinSDEIVary0 <- function(n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, ou = FALSE) {
    .Call(`_simStateSpace_SimSSMLinSDEIVary0`, n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, ou)
}

.SimSSMLinSDEIVary1 <- function(n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, x, gamma, ou = FALSE) {
    .Call(`_simStateSpace_SimSSMLinSDEIVary1`, n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, x, gamma, ou)
}

.SimSSMLinSDEIVary2 <- function(n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, x, gamma, kappa, ou = FALSE) {
    .Call(`_simStateSpace_SimSSMLinSDEIVary2`, n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, x, gamma, kappa, ou)
}

.SolveLya <- function(A, Q) {
    .Call(`_simStateSpace_SolveLya`, A, Q)
}

.SolveSyl <- function(A, B, C) {
    .Call(`_simStateSpace_SolveSyl`, A, B, C)
}

#' Test the Drift Matrix
#'
#' Both have to be true for the function to return `TRUE`.
#'   - Test that the real part of all eigenvalues of \eqn{\boldsymbol{\Phi}}
#'     are less than zero.
#'   - Test that the diagonal values of \eqn{\boldsymbol{\Phi}}
#'     are between 0 to negative inifinity.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param phi Numeric matrix.
#'   The drift matrix (\eqn{\boldsymbol{\Phi}}).
#'
#' @examples
#' phi <- matrix(
#'   data = c(
#'     -0.357, 0.771, -0.450,
#'     0.0, -0.511, 0.729,
#'     0, 0, -0.693
#'   ),
#'   nrow = 3
#' )
#' TestPhi(phi = phi)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace test linsde
#' @export
TestPhi <- function(phi) {
    .Call(`_simStateSpace_TestPhi`, phi)
}

#' Test Stability
#'
#' The function computes the eigenvalues of the input matrix `x`.
#' It checks if the real part of all eigenvalues is negative.
#' If all eigenvalues have negative real parts,
#' the system is considered stable.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param x Numeric matrix.
#'
#' @examples
#' x <- matrix(
#'   data = c(
#'     -0.357, 0.771, -0.450,
#'     0.0, -0.511, 0.729,
#'     0, 0, -0.693
#'   ),
#'   nrow = 3
#' )
#' TestStability(x)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace test linsde
#' @export
TestStability <- function(x) {
    .Call(`_simStateSpace_TestStability`, x)
}

#' Test Stationarity
#'
#' The function computes the eigenvalues of the input matrix `x`.
#' It checks if all eigenvalues have moduli less than 1.
#' If all eigenvalues have moduli less than 1,
#' the system is considered stationary.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param x Numeric matrix.
#'
#' @examples
#' x <- matrix(
#'   data = c(0.5, 0.3, 0.2, 0.4),
#'   nrow = 2
#' )
#' TestStationarity(x)
#'
#' x <- matrix(
#'   data = c(0.9, -0.5, 0.8, 0.7),
#'   nrow = 2
#' )
#' TestStationarity(x)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace test ssm
#' @export
TestStationarity <- function(x) {
    .Call(`_simStateSpace_TestStationarity`, x)
}

