% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_dependence.R
\name{sv_dependence}
\alias{sv_dependence}
\alias{sv_dependence.default}
\alias{sv_dependence.shapviz}
\alias{sv_dependence.mshapviz}
\title{SHAP Dependence Plot}
\usage{
sv_dependence(object, ...)

\method{sv_dependence}{default}(object, ...)

\method{sv_dependence}{shapviz}(
  object,
  v,
  color_var = "auto",
  color = "#3b528b",
  viridis_args = getOption("shapviz.viridis_args"),
  jitter_width = NULL,
  interactions = FALSE,
  ih_nbins = NULL,
  ih_color_num = TRUE,
  ih_scale = FALSE,
  ih_adjusted = FALSE,
  share_y = FALSE,
  ylim = NULL,
  seed = 1L,
  ...
)

\method{sv_dependence}{mshapviz}(
  object,
  v,
  color_var = "auto",
  color = "#3b528b",
  viridis_args = getOption("shapviz.viridis_args"),
  jitter_width = NULL,
  interactions = FALSE,
  ih_nbins = NULL,
  ih_color_num = TRUE,
  ih_scale = FALSE,
  ih_adjusted = FALSE,
  share_y = FALSE,
  ylim = NULL,
  seed = 1L,
  ...
)
}
\arguments{
\item{object}{An object of class "(m)shapviz".}

\item{...}{Arguments passed to \code{\link[ggplot2:geom_jitter]{ggplot2::geom_jitter()}}.}

\item{v}{Column name of feature to be plotted. Can be a vector/list if \code{object} is
of class "shapviz".}

\item{color_var}{Feature name to be used on the color scale to investigate
interactions. The default ("auto") uses SHAP interaction values (if available),
or a heuristic to select the strongest interacting feature. Set to \code{NULL} to not
use the color axis. Can be a vector/list if \code{object} is of class "shapviz".}

\item{color}{Color to be used if \code{color_var = NULL}. Can be a vector/list if \code{v}
is a vector.}

\item{viridis_args}{List of viridis color scale arguments, see
\code{?ggplot2::scale_color_viridis_c}. The default points to the global option
\code{shapviz.viridis_args}, which corresponds to
\code{list(begin = 0.25, end = 0.85, option = "inferno")}.
These values are passed to \verb{ggplot2::scale_color_viridis_*()}.
For example, to switch to a standard viridis scale, you can either change the
default via \code{options(shapviz.viridis_args = list())}, or set
\code{viridis_args = list()}. Only relevant if \code{color_var} is not \code{NULL}.}

\item{jitter_width}{The amount of horizontal jitter. The default (\code{NULL}) will
use a value of 0.2 in case \code{v} is discrete, and no jitter otherwise.
(Numeric variables are considered discrete if they have at most 7 unique values.)
Can be a vector/list if \code{v} is a vector.}

\item{interactions}{Should SHAP interaction values be plotted? Default is \code{FALSE}.
Requires SHAP interaction values. If \code{color_var = NULL} (or is equal to \code{v}),
the pure main effect of \code{v} is visualized. Otherwise, twice the SHAP interaction
values between \code{v} and the \code{color_var} are plotted.}

\item{ih_nbins, ih_color_num, ih_scale, ih_adjusted}{Interaction heuristic (ih)
parameters used to select the color variable, see \code{\link[=potential_interactions]{potential_interactions()}}.
Only used if \code{color_var = "auto"} and if there are no SHAP interaction values.}

\item{share_y}{Should y axis be shared across subplots? The default is FALSE.
Has no effect if \code{ylim} is passed. Only for multiple plots.}

\item{ylim}{A vector of length 2 with manual y axis limits applied to all plots.}

\item{seed}{Random seed for jittering. Default is 1L. Note that this does not
modify the global seed.}
}
\value{
An object of class "ggplot" (or "patchwork") representing a dependence plot.
}
\description{
Scatterplot of the SHAP values of a feature against its feature values.
If SHAP interaction values are available, setting \code{interactions = TRUE} allows
to focus on pure interaction effects (multiplied by two) or on pure main effects.
By default, the feature on the color scale is selected via SHAP interactions
(if available) or an interaction heuristic, see \code{\link[=potential_interactions]{potential_interactions()}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{sv_dependence(default)}: Default method.

\item \code{sv_dependence(shapviz)}: SHAP dependence plot for "shapviz" object.

\item \code{sv_dependence(mshapviz)}: SHAP dependence plot for "mshapviz" object.

}}
\examples{
dtrain <- xgboost::xgb.DMatrix(
  data.matrix(iris[, -1]),
  label = iris[, 1], nthread = 1
)
fit <- xgboost::xgb.train(data = dtrain, nrounds = 10, nthread = 1)
x <- shapviz(fit, X_pred = dtrain, X = iris)
sv_dependence(x, "Petal.Length")
sv_dependence(x, "Petal.Length", color_var = "Species")
sv_dependence(x, "Petal.Length", color_var = NULL)
sv_dependence(x, c("Species", "Petal.Length"), share_y = TRUE)
sv_dependence(x, "Petal.Width", color_var = c("Species", "Petal.Length")) +
  patchwork::plot_layout(ncol = 1)

# SHAP interaction values/main effects
x2 <- shapviz(fit, X_pred = dtrain, X = iris, interactions = TRUE)
sv_dependence(x2, "Petal.Length", interactions = TRUE)
sv_dependence(
  x2, c("Petal.Length", "Species"),
  color_var = NULL, interactions = TRUE
)
sv_dependence(
  x2, "Petal.Length",
  color_var = colnames(iris[-1]), interactions = TRUE,
  share_y = TRUE
)
}
\seealso{
\code{\link[=potential_interactions]{potential_interactions()}}
}
