% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature.selection.R
\name{feature.selection}
\alias{feature.selection}
\title{Selects the top features with highest weighted mean shap values based on the
       specified criteria}
\usage{
feature.selection(
  shapley,
  method = "mean",
  cutoff = 0,
  top_n_features = NULL,
  features = NULL
)
}
\arguments{
\item{shapley}{shapley object}

\item{method}{Character. The column name in \code{summaryShaps} used
for feature selection. Default is \code{"mean"}, which
selects important features which have weighted mean shap
ratio (WMSHAP) higher than the specified cutoff. Other
alternative is "lowerCI", which selects features which
their lower bound of confidence interval is higher than
the cutoff.}

\item{cutoff}{numeric, specifying the cutoff for the method used for selecting
the top features. the default is zero, which means that all
features with the "method" criteria above zero will be selected.}

\item{top_n_features}{integer. if specified, the top n features with the
highest weighted SHAP values will be selected, overrullung
the 'cutoff' and 'method' arguments.}

\item{features}{character vector, specifying the feature to be plotted.}
}
\value{
normalized numeric vector
}
\description{
This function specifies the top features and prepares the data
             for plotting SHAP contributions for each row, or summary of absolute
             SHAP contributions for each feature.
}
\author{
E. F. Haghish
}
