% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.sgs}
\alias{predict.sgs}
\title{Predict using one of the following object types: \code{"sgs"}, \code{"sgs_cv"}, \code{"gslope"}, \code{"gslope_cv"}.}
\usage{
\method{predict}{sgs}(object, x, ...)
}
\arguments{
\item{object}{Object of one of the following classes: \code{"sgs"}, \code{"sgs_cv"}, \code{"gslope"}, \code{"gslope_cv"}.}

\item{x}{Input data to use for prediction.}

\item{...}{further arguments passed to stats function.}
}
\value{
A list containing:
\item{response}{The predicted response. In the logistic case, this represents the predicted class probabilities.}
\item{class}{The predicted class assignments. Only returned if type = "logistic" in the model object.}
}
\description{
Performs prediction from one of the following fits: \code{\link[=fit_sgs]{fit_sgs()}}, \code{\link[=fit_sgs_cv]{fit_sgs_cv()}}, \code{\link[=fit_gslope]{fit_gslope()}}, \code{\link[=fit_gslope_cv]{fit_gslope_cv()}}, \code{\link[=fit_sgo]{fit_sgo()}}, \code{\link[=fit_sgo_cv]{fit_sgo_cv()}}, \code{\link[=fit_goscar]{fit_goscar()}}, \code{\link[=fit_goscar_cv]{fit_goscar_cv()}}. The predictions are calculated for each \code{"lambda"} value in the path.
}
\examples{
# specify a grouping structure
groups = c(1,1,1,2,2,3,3,3,4,4)
# generate data
data =  gen_toy_data(p=10, n=5, groups = groups, seed_id=3,group_sparsity=1)
# run SGS 
model = fit_sgs(X = data$X, y = data$y, groups = groups, type="linear", lambda = 1, alpha=0.95, 
vFDR=0.1, gFDR=0.1, standardise = "l2", intercept = TRUE, verbose=FALSE)
# use predict function
model_predictions = predict(model, x = data$X)
}
\seealso{
\code{\link[=fit_sgs]{fit_sgs()}}, \code{\link[=fit_sgs_cv]{fit_sgs_cv()}}, \code{\link[=fit_gslope]{fit_gslope()}}, \code{\link[=fit_gslope_cv]{fit_gslope_cv()}}, \code{\link[=fit_sgo]{fit_sgo()}}, \code{\link[=fit_sgo_cv]{fit_sgo_cv()}}, \code{\link[=fit_goscar]{fit_goscar()}}, \code{\link[=fit_goscar_cv]{fit_goscar_cv()}}

Other SGS-methods: 
\code{\link{as_sgs}()},
\code{\link{coef.sgs}()},
\code{\link{fit_sgo}()},
\code{\link{fit_sgo_cv}()},
\code{\link{fit_sgs}()},
\code{\link{fit_sgs_cv}()},
\code{\link{plot.sgs}()},
\code{\link{print.sgs}()},
\code{\link{scaled_sgs}()}

Other gSLOPE-methods: 
\code{\link{coef.sgs}()},
\code{\link{fit_goscar}()},
\code{\link{fit_goscar_cv}()},
\code{\link{fit_gslope}()},
\code{\link{fit_gslope_cv}()},
\code{\link{plot.sgs}()},
\code{\link{print.sgs}()}
}
\concept{SGS-methods}
\concept{gSLOPE-methods}
