% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envelope.sglg.R
\name{envelope.sglg}
\alias{envelope.sglg}
\title{envelope.sglg}
\usage{
envelope.sglg(fit, Rep)
}
\arguments{
\item{fit}{an object of the class sglg. This object is returned from the call to glg(), sglg().}

\item{Rep}{a positive integer. This is the number of replications on which to build the simulated envelope. Default is Rep=50.}
}
\description{
Build a Normal probability plot with simulated envelope for a deviance-type residuals
in semiparametric or multiple linear generalized log-gamma regression models.
}
\examples{
rows <- 120
columns <- 2
t_beta  <- c(0.5, 2)
t_sigma <- 0.5
t_lambda <- 1
set.seed(8142031)
x1 <- rbinom(rows, 1, 0.5)
x2 <- runif(columns, 0, 1)
X <- cbind(x1,x2)
error <- rglg(rows, 0, 1, t_lambda)
y1 <- X \%*\%t_beta + t_sigma * error
data.example <- data.frame(y1,X)
fit <- glg(y1 ~ x1 + x2 - 1,data=data.example)
envelope.sglg(fit,Rep=50)
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.

Cardozo C.A.,  Paula G., and Vanegas L. (2022). Generalized log-gamma additive partial linear models with P-spline smoothing. Statistical Papers.

Ortega, E., Paula, G. A. and Bolfarine, H. (2008) Deviance residuals in generalized log-gamma regression models with censored observations. Journal of Statistical Computation and Simulation, 78, 747-764.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
