% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N_model.R
\name{N_model}
\alias{N_model}
\title{Analysis: Graph for not significant trend}
\usage{
N_model(
  trat,
  resp,
  ylab = "Germination (\%)",
  error = "SE",
  legend = "not~signifcant",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  width.bar = NA,
  legend.position = "top",
  textsize = 12,
  pointsize = 4.5,
  linesize = 0.8,
  pointshape = 21,
  font.family = "sans"
)
}
\arguments{
\item{trat}{Numerical vector with treatments (Declare as numeric)}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{legend}{Add the legend}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{width.bar}{Bar width}

\item{legend.position}{Legend position (\emph{default} is "top")}

\item{textsize}{Font size}

\item{pointsize}{shape size}

\item{linesize}{line size}

\item{pointshape}{format point (\emph{default} is 21)}

\item{font.family}{Font family (\emph{default} is sans)}
}
\value{
The function returns an exploratory graph of segments
}
\description{
Graph for non-significant trend. Can be used within the multicurve command
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)

#================================
# Germination
#================================
N_model(trat,germ)

#================================
# Germination speed
#================================
N_model(trat, vel, ylab=expression("v"~(dias^-1)))
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{non-significant}
