% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dUtility.R
\docType{methods}
\name{dUtility}
\alias{dUtility}
\title{Data-Utility measures}
\usage{
dUtility(obj, ...)
}
\arguments{
\item{obj}{original data or object of class \linkS4class{sdcMicroObj}}

\item{...}{see arguments below
\itemize{
\item xm: perturbed data
\item method: method IL1, IL1s or eigen. More methods are implemented in
summary.micro()
}}
}
\value{
data utility or modified entry for data utility the \linkS4class{sdcMicroObj}.
}
\description{
\code{\link[=dUtility]{dUtility()}} allows to compute different measures of data-utility based
on various distances using original and perturbed variables.
}
\details{
The standardised distances of the perturbed data values to the original ones
are measured. The following measures are available:
\itemize{
\item \verb{"IL1}: sum of absolute distances between original and perturbed variables
scaled by absolute values of the original variables
\item \verb{"IL1s}: measures the absolute distances between original
and perturbed ones, scaled by the standard deviation of original variables times
the square root of \code{2}.
\item \verb{"eigen}; compares the eigenvalues of original and perturbed data
\item \verb{"robeigen}; compares robust eigenvalues of original and perturbed data
}
}
\examples{
data(free1)
free1 <- as.data.frame(free1)
\donttest{
m1 <- microaggregation(free1[, 31:34], method="onedims", aggr=3)
m2 <- microaggregation(free1[, 31:34], method="pca", aggr=3)
dRisk(obj=free1[, 31:34], xm=m1$mx)
dRisk(obj=free1[, 31:34], xm=m2$mx)
dUtility(obj=free1[, 31:34], xm=m1$mx)
dUtility(obj=free1[, 31:34], xm=m2$mx)
data(Tarragona)
x <- Tarragona[, 5:7]
y <- addNoise(x)$xm
dRiskRMD(x, xm=y)
dRisk(x, xm=y)
dUtility(x, xm = y, method = "IL1")
dUtility(x, xm = y, method = "IL1s")
dUtility(x, xm = y, method = "eigen")
dUtility(x, xm = y, method = "robeigen")

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
## this is already made internally, so you don't need to run this:
sdc <- dUtility(sdc)
}
}
\references{
for IL1 and IL1s: see Mateo-Sanz, Sebe, Domingo-Ferrer.
Outlier Protection in Continuous Microdata Masking.
International Workshop on Privacy in Statistical Databases.
PSD 2004: Privacy in Statistical Databases pp 201-215.

Templ, M. and Meindl, B., \verb{Robust Statistics Meets SDC: New Disclosure Risk Measures for Continuous Microdata Masking}, Lecture Notes in Computer
Science, Privacy in Statistical Databases, vol. 5262, pp. 113-126, 2008.
}
\seealso{
\code{\link[=dRisk]{dRisk()}}, \code{\link[=dRiskRMD]{dRiskRMD()}}
}
\author{
Matthias Templ
}
\keyword{manip}
