% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{with_rng_state}
\alias{with_rng_state}
\title{Set RNG Sate before Running a Function}
\usage{
with_rng_state(fun, args, seed)
}
\arguments{
\item{fun}{(\code{function})\cr
Function to run.}

\item{args}{(\code{list})\cr
Arguments to pass to \code{fun}.}

\item{seed}{(\code{integer})\cr
RNG state to set before running \code{fun}.}
}
\value{
\code{any}
}
\description{
This function sets the rng state before running a function.
Use with caution.
The global environment is changed.
}
\examples{
with_rng_state(runif, list(n = 1), .Random.seed)
}
\keyword{internal}
