% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.summary.roclearn.R
\name{summary.cv.roclearn}
\alias{summary.cv.roclearn}
\title{Summarize Cross-Validation results for linear models}
\usage{
\method{summary}{cv.roclearn}(object, ...)
}
\arguments{
\item{object}{A fitted cross-validation object of class
\code{"cv.roclearn"} (linear).}

\item{...}{Not used.}
}
\value{
Invisibly returns the input \code{object}, after printing a summary
to the console.
}
\description{
Print a concise summary of cross-validation results for a linear model.
}
\details{
This is a method for the generic \code{summary()} function, applied to
objects of class \code{"cv.roclearn"}. It prints training settings
(loss, penalty, number of folds, the set of candidate \eqn{\lambda}),
the selected optimal \eqn{\lambda}, the corresponding mean and standard
deviation of cross-validated AUC, and a truncated table of AUC results
across candidate \eqn{\lambda} values.
}
\examples{
set.seed(123)

n <- 100
n_pos <- round(0.2 * n)
n_neg <- n - n_pos
X <- rbind(
  matrix(rnorm(2 * n_neg, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos, mean =  1), ncol = 2)
)
y <- c(rep(-1, n_neg), rep(1, n_pos))

cvfit <- cv.roclearn(
  X, y,
  lambda.vec = exp(seq(log(0.01), log(5), length.out = 3)),
  approx=TRUE, nfolds = 2
)

summary(cvfit)
}
