% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxLP.R
\name{coxLP}
\alias{coxLP}
\alias{coxLP.cph}
\alias{coxLP.coxph}
\alias{coxLP.phreg}
\alias{coxLP.prodlim}
\alias{coxLP.GLMnet}
\title{Compute the linear predictor of a Cox model}
\usage{
coxLP(object, data, center)

\method{coxLP}{cph}(object, data, center)

\method{coxLP}{coxph}(object, data, center)

\method{coxLP}{phreg}(object, data, center)

\method{coxLP}{prodlim}(object, data, center)

\method{coxLP}{GLMnet}(object, data, center = FALSE)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}

\item{data}{a \code{data.frame} or a \code{data.table}}

\item{center}{should the linear predictor be computed after centering the covariates}
}
\description{
Compute the linear predictor of a Cox model
}
\details{
In case of empty linear predictor returns a vector of 0 with the same length as the number of rows of the dataset
}
\author{
Brice Ozenne broz@sund.ku.dk
}
