% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intcal_json.R
\name{intcal.plot.record}
\alias{intcal.plot.record}
\title{Plot an IntCal20 record}
\usage{
intcal.plot.record(
  i,
  col = rgb(0, 0, 1, 0.5),
  pch = 19,
  pch.cex = 0.3,
  lwd = 1,
  lty = 1,
  cal.lim = c(),
  C14.lim = c(),
  add = FALSE,
  cal.lab = c(),
  C14.lab = c(),
  ka = FALSE,
  as.F = FALSE,
  as.pMC = FALSE,
  draw.z = TRUE,
  draw.calsigma = TRUE,
  grid = FALSE,
  grid.lty = 2,
  grid.col = rgb(0, 0, 0, 0.5),
  draw.cc = 1,
  cc.col = rgb(0, 0.5, 0, 0.5),
  legend.loc = "topleft",
  legend.cex = 0.5
)
}
\arguments{
\item{i}{The IntCal record, in the order as they appear in the IntCal20 json file (140 entries). Must be a single integer between 1 and 140.}

\item{col}{Colour of the symbols. Defaults to semi-transparent blue, \code{col=rgb(0,0,1,.5)}.}

\item{pch}{Symbol of the dates. Defaults to a filled circle, pch=20.}

\item{pch.cex}{Size of the symbol. Defaults to 0.3.}

\item{lwd}{Line width of the error bars. Defaults to 1.}

\item{lty}{Line type of the error bars. Defaults to continuous, 1.}

\item{cal.lim}{Limits of the horizontal/calendar scale. Calculated automatically by default.}

\item{C14.lim}{Limits of the C-14 scale. Calculated automatically by default}

\item{add}{Make a new plot (default, \code{add=FALSE}). The alternative is to add to an existing plot.}

\item{cal.lab}{Label of the calendar axis. Defaults to 'cal BP' or 'kcal BP'.}

\item{C14.lab}{Label of the C-14 axis. Defaults to '14C BP' or '14C kBP'}

\item{ka}{Whether or not to use ka (thousands of years). Defaults to FALSE (i.e., cal BP).}

\item{as.F}{Return the F values, calculated from the C14 ages (columns 2 and 3). Defaults to \code{as.F=FALSE}.}

\item{as.pMC}{Return the pMC values, calculated from the C14 ages (columns 2 and 3). Defaults to \code{as.pMC=FALSE}.}

\item{draw.z}{Whether or not to plot the spread in calendar years of blocks of (mostly) tree rings. This is for tree-ring datasets where individual dates were taken on blocks of rings covering e.g. 10 or 20 years.}

\item{draw.calsigma}{Whether or not to plot the calendar age uncertainties where available.}

\item{grid}{Whether or not to add a grid to the plot.}

\item{grid.lty}{Line type of the grid.}

\item{grid.col}{Colour of the grid.}

\item{draw.cc}{Whether or not to also plot the calibration curve. Defaults to plotting the IntCal20 calibration curve, but can also be set to 2 (Marine20), 3 (SHCal20), or NA (none).}

\item{cc.col}{Colour of the calibration curve. Defaults to semi-transparent darkgreen, \code{cc.col=rgb(0,.5,0,.5)}.}

\item{legend.loc}{Location of the legend. Defaults to top right. Set to NA if you don't want to plot the legend.}

\item{legend.cex}{Relative size of the font of the legend. Defaults to 0.5.}
}
\value{
A plot of the calendar and radiocarbon ages, indicating uncertainties (error bars) and age blocks (e.g, for trees where blocks of >1 rings were dated) where relevant.
}
\description{
Plot the calendar and radiocarbon data of an IntCal20 record
}
\examples{
 record_1 <- intcal.plot.record(1)
 record_10 <- intcal.plot.record(10, add=TRUE, col=rgb(1,0,0,.5), legend.loc="bottomright")
}
\seealso{
\code{\link{intcal.extract.record}}
}
