% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-upload.R
\name{gcs_to_ee_image}
\alias{gcs_to_ee_image}
\title{Move a GeoTIFF image from GCS to their EE assets}
\usage{
gcs_to_ee_image(
  manifest,
  overwrite = FALSE,
  command_line_tool_path = NULL,
  quiet = FALSE
)
}
\arguments{
\item{manifest}{Character. Manifest upload file. See \code{\link{ee_utils_create_manifest_image}}.}

\item{overwrite}{Logical. If TRUE, the assetId will be overwritten if
it exists.}

\item{command_line_tool_path}{Character. Path to the Earth Engine command line
tool (CLT). If NULL, rgee assumes that CLT is set in the system PATH.
(ignore if \code{via} is not defined as "gcs_to_asset").}

\item{quiet}{Logical. Suppress info message.}
}
\value{
Character. The Earth Engine asset ID.
}
\description{
Move a GeoTIFF image from GCS to their EE assets
}
\examples{
\dontrun{
library(rgee)
library(stars)
ee_Initialize("csaybar", gcs = TRUE)

# 1. Read GeoTIFF file and create a output filename
tif <- system.file("tif/L7_ETMs.tif", package = "stars")
x <- read_stars(tif)
assetId <- sprintf("\%s/\%s",ee_get_assethome(),'stars_l7')

# 2. From local to gcs
gs_uri <- local_to_gcs(
  x = tif,
  bucket = 'rgee_dev' # Insert your own bucket here!
)

# 3. Create an Image Manifest
manifest <- ee_utils_create_manifest_image(gs_uri, assetId)

# 4. From GCS to Earth Engine
gcs_to_ee_image(
  manifest = manifest,
  overwrite = TRUE
)

# OPTIONAL: Monitoring progress
ee_monitoring()

# OPTIONAL: Display results
ee_stars_01 <- ee$Image(assetId)
ee_stars_01$bandNames()$getInfo()

Map$centerObject(ee_stars_01)
Map$addLayer(ee_stars_01, list(min = 0, max = 255, bands = c("b3", "b2", "b1")))
}
}
